clear all
/////////////////////////////////////////////////////
///////////// Stata script written by:
///// Zuhaib Mahmood
///// 2017-2019
/////
///////////// Additional variable coding provided by:
///// Nikolas Frantz
///// 2017-2018
/////
///// Haining Du
///// 2018-2019
/////
///////////// Stata script adapted from:
///// Nicolas Bichay
///// 2016-2017
///// Republican Revolution Analysis Do-File
/////
////////////// DEPENDENCIES: 
///// (1) coefplot
///// (2) xtserial
/////////////////////////////////////////////////////

//Working directory
cd "/Users/Z/Dropbox/Z/Michigan State 2013/2018-2019/Spring 2019/IPPSR_RA/0_to2014_upd/"


//////////////////////////
////////
// CODE
//
// NO MORE USER INPUTS AFTER THIS POINT
////////
//////////////////////////

//////////////
//Create the dataset
//////////////
cd "SCRIPTS/0_dataset"

// Create data
do create_dataset.do
cd "../SCRIPTS/0_dataset/"

// Merge in updated
do create_upd_merged.do
cd "../../SCRIPTS/1_variables/"

////////////////
// Generate our variables
////////////////

//////////////
// Liberal Policy Count variable
//// (1) our measure of counts
//// (2) Grumbach (2017) measure of lib/cons
//// (3) Grossman's (2017) coding of lib/cons, with and without non-caughney measures
//// (4) Updated coding by Nik (2018), Boehmke's ME coding
//// (5) Updated coding by Nik (2018), Boehmke's FD coding
//// (6) Updated coding by Nik (2018), Grumbach coding
//////////////
do gen_count_vars_libcons.do
do gen_grumbach_libcons.do
do gen_grsman_vars_libcons.do
do gen_upd_nikconv_vars_libcons.do
do gen_upd_niksizescope_vars_libcons.do
do gen_upd_nikboehmME_vars_libcons.do
do gen_upd_nikboehmFD_vars_libcons.do
do gen_upd_nikgrumb_vars_libcons.do

// Create variables
do create_variables
cd "../../SCRIPTS"

////////////////
//Save data
////////////////

// Save a copy for variable checking
cd "../zm_varcheck"
saveold dataset.dta,replace
cd "../SCRIPTS"

// Save a copy for models and post-estimation
cd "../OUTPUT"
saveold RepRev.dta,replace
cd "../OUTPUT"

//////////////
// Descriptives
//////////////

cd "../SCRIPTS/2_descriptive"
do descriptive_stats.do
cd "../OUTPUT"

/////////////////////////
//Panel Model estimation
/////////////////////////
clear all
use RepRev.dta
drop if year<1985

//Estimate LIB panel models. Then, run post-estimation.
cd "../SCRIPTS/3a_panel_models/"
do Lib_models_panel.do
cd "../3b_panel_post/"
do Lib_post_panel.do
cd "../../../OUTPUT"

//Estimate CONS panel models. Then, run post-estimation.
clear all
use RepRev.dta
drop if year<1985

cd "../SCRIPTS/3a_panel_models/"
do Cons_models_panel.do
cd "../3b_panel_post/"
do Cons_post_panel.do
cd "../../../OUTPUT"

//Estimate NET LIB panel models. Then, run post-estimation.
clear all
use RepRev.dta
drop if year<1985

cd "../SCRIPTS/3a_panel_models/"
do NetLib_models_panel.do
cd "../3b_panel_post/"
do NetLib_post_panel.do
cd "../../../OUTPUT"

//Estimate OTHER panel models. Then, run post-estimation.
clear all
use RepRev.dta
drop if year<1985

cd "../SCRIPTS/3a_panel_models/"
do Other_models_panel.do
cd "../3b_panel_post/"
do Other_post_panel.do
cd "../../../OUTPUT"

/////////////////////////
//Change Model estimation
/////////////////////////
clear all
use RepRev.dta
drop if year<1985

//Estimate LIB change models. Then, run post-estimation.
cd "../SCRIPTS/4a_change_models/"
do Lib_models_change.do
cd "../4b_change_post/"
do Lib_post_change.do
cd "../../../OUTPUT"

//Estimate CONS change models. Then, run post-estimation.
clear all
use RepRev.dta
drop if year<1985

cd "../SCRIPTS/4a_change_models/"
do Cons_models_change.do
cd "../4b_change_post/"
do Cons_post_change.do
cd "../../../OUTPUT"

//Estimate NET LIB change models. Then, run post-estimation.
clear all
use RepRev.dta
drop if year<1985

cd "../SCRIPTS/4a_change_models/"
do NetLib_models_change.do
cd "../4b_change_post/"
do NetLib_post_change.do
cd "../../../OUTPUT"

//Estimate OTHER change models. Then, run post-estimation.
clear all
use RepRev.dta
drop if year<1985

cd "../SCRIPTS/4a_change_models/"
do Other_models_change.do
cd "../4b_change_post/"
do Other_post_change.do
cd "../../../OUTPUT"

/////////////////////////////////////////////////
/////////////// Descriptive tabular stats
/////////////////////////////////////////////////
cd "../OUTPUT"

// Tabulate variables, assuming control variables kept, panel model
keep if Lrep_chambers!=. & region!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
estpost sum liberalsize liberalcoal LibPolicyUpd LibPolicyConv LibGrumb LibPolicyGrsman LibPolNCGrsman conservsize conservcoal ConsPolicyUpd ConsPolicyConv ConsGrumb ConsPolicyGrsman ConsPolNCGrsman netlibsize netlibcoal NetLibPolUpd NetLibPolConv NetLibGrumb NetLibPolGrsman NetLibPolNCGrsman
esttab . using "Panel_Desc_PolicyCt.rtf",rtf replace  cells("count mean sd min max") nomtitle nonumber noobs title("Policy counts, descriptive")
estpost sum total_expenditure_gsp pollib_median policyeconlib_est policysociallib_est ln_innovate innovatescore_boehmkeskinner
esttab . using "Panel_Desc_Other.rtf",rtf replace  cells("count mean sd min max") nomtitle nonumber noobs title("Other measures, descriptive")

// Tabulate variables, assuming control variables kept, change model
clear
use RepRev.dta
keep if rep_change_factor!=. & region!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
estpost sum LibSize19change LibConv19change LibPolicyUpdChange LibPolicyConvChange LibGrumbChange LibGrsmanChange LibGrsmanNCChange ConsSize19change ConsConv19change ConsPolicyUpdChange ConsPolicyConvChange ConsGrumbChange ConsGrsmanChange ConsGrsmanNCChange NetLibSize19change NetLibConv19change NetLibPolUpdChange NetLibPolConvChange NetLibGrumbChange NetLibGrsmanChange NetLibGrsmanNCChange
esttab . using "Change_Desc_PolicyCt.rtf",rtf replace  cells("count mean sd min max") nomtitle nonumber noobs title("Policy counts (changes), descriptive")
estpost sum expend_change innov_change lib_change EconLib_change SocLib_change
esttab . using "Change_Desc_Other.rtf",rtf replace  cells("count mean sd min max") nomtitle nonumber noobs title("Other measures (changes), descriptive")

// Tabulate variables, baseline vars kept, panel model
clear
use RepRev.dta
keep if Lrep_chambers!=. & south!=. & year>1990 & year<2015
estpost sum liberalsize liberalcoal LibPolicyUpd LibPolicyConv LibGrumb LibPolicyGrsman LibPolNCGrsman conservsize conservcoal ConsPolicyUpd ConsPolicyConv ConsGrumb ConsPolicyGrsman ConsPolNCGrsman netlibsize netlibcoal NetLibPolUpd NetLibPolConv NetLibGrumb NetLibPolGrsman NetLibPolNCGrsman
esttab . using "Panel_Base_Desc_PolicyCt.rtf",rtf replace  cells("count mean sd min max") nomtitle nonumber noobs title("Policy counts, descriptive, baseline models")
estpost sum total_expenditure_gsp pollib_median policyeconlib_est policysociallib_est ln_innovate innovatescore_boehmkeskinner
esttab . using "Panel_Base_Desc_Other.rtf",rtf replace  cells("count mean sd min max") nomtitle nonumber noobs title("Other measures, descriptive, baseline models")

// Tabulate variables, baseline vars kept, change model
clear
use RepRev.dta
keep if rep_change_factor!=. & region!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
estpost sum LibSize19change LibConv19change LibPolicyUpdChange LibPolicyConvChange LibGrumbChange LibGrsmanChange LibGrsmanNCChange ConsSize19change ConsConv19change ConsPolicyUpdChange ConsPolicyConvChange ConsGrumbChange ConsGrsmanChange ConsGrsmanNCChange NetLibSize19change NetLibConv19change NetLibPolUpdChange NetLibPolConvChange NetLibGrumbChange NetLibGrsmanChange NetLibGrsmanNCChange
esttab . using "Change_Base_Desc_PolicyCt.rtf",rtf replace  cells("count mean sd min max") nomtitle nonumber noobs title("Policy counts (changes), descriptive, baseline models")
estpost sum expend_change innov_change lib_change EconLib_change SocLib_change
esttab . using "Change_Base_Desc_Other.rtf",rtf replace  cells("count mean sd min max") nomtitle nonumber noobs title("Other measures (changes), descriptive, baseline models")

/////////////////////
// Bar plots for every variable across years, if needed.
/////////////////////
/*
/// Panel regression descriptives (non-missing data)
count if LibPolicyUpd!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if LibPolicyUpd!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
graph bar (count) stated if LibPolicyConv!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibGrumb!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibPolicyGrsman!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibPolNCGrsman!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolicyUpd!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolicyConv!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsGrumb!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolicyGrsman!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolNCGrsman!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolUpd!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolConv!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibGrumb!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolGrsman!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolNCGrsman!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
count if total_expenditure_gsp!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if total_expenditure_gsp!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if pollib_median!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if pollib_median!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if policyeconlib_est!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if policyeconlib_est!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if policysociallib_est!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if policysociallib_est!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if ln_innovate!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if ln_innovate!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if innovatescore_boehmkeskinner!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if innovatescore_boehmkeskinner!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)

/// Change model descriptives (non-missing data)
count if LibPolicyUpdChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if LibPolicyUpdChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
graph bar (count) stated if LibPolicyConvChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibGrumbChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibGrsmanChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibGrsmanNCChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolicyUpdChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolicyConvChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsGrumbChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsGrsmanChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsGrsmanNCChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolUpdChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolConvChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibGrumbChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibGrsmanChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibGrsmanNCChange!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
count if expend_change!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if expend_change!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if lib_change!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if lib_change!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if SocLib_change!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if SocLib_change!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if EconLib_change!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if EconLib_change!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if innov_change!=. & rep_change_factor!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015
graph bar (count) stated if innov_change!=. & Lrep_chambers!=. & region_census!=. & nonwhite!=. & lnPop!=. & lnGSP!=. & ln_pcincome!=. & masssociallib_est!=. & masseconlib_est!=. & citi6013!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)


//////////////
// baseline models
//////////////

/// Panel regression descriptives (non-missing data)
count if LibPolicyUpd!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if LibPolicyUpd!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
graph bar (count) stated if LibPolicyConv!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibGrumb!=. & Lrep_chambers!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibPolicyGrsman!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibPolNCGrsman!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolicyUpd!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolicyConv!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsGrumb!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolicyGrsman!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolNCGrsman!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolUpd!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolConv!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolGrsman!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolNCGrsman!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
count if total_expenditure_gsp!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if total_expenditure_gsp!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if pollib_median!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if pollib_median!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if policyeconlib_est!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if policyeconlib_est!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if policysociallib_est!=. & Lrep_chambers!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if policysociallib_est!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if ln_innovate!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if ln_innovate!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if innovatescore_boehmkeskinner!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if innovatescore_boehmkeskinner!=. & Lrep_chambers!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)

/// Change model descriptives (non-missing data)
count if LibPolicyUpdChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if LibPolicyUpdChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
graph bar (count) stated if LibPolicyConvChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibGrumbChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibGrsmanChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if LibGrsmanNCChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolicyUpdChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsPolicyConvChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsGrumbChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsGrsmanChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if ConsGrsmanNCChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolUpdChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibPolConvChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibGrumbChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibGrsmanChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
graph bar (count) stated if NetLibGrsmanNCChange!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015")
count if expend_change!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if expend_change!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if lib_change!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if lib_change!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if SocLib_change!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if SocLib_change!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if EconLib_change!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if EconLib_change!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
count if innov_change!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015
graph bar (count) stated if innov_change!=. & rep_change_factor!=. & south!=. & year>1990 & year<2015,over(st,label(labsize("tiny"))) title("Distribution of states, 1990-2015") subtitle(`r(N)' observations)
*/
