/////////////////////////////////////////////////////
///////////// Create dataset (merge together all source data)
/////////////////////////////////////////////////////

// read CSV files, export as DTA files
cd "../../SOURCE/csp2017_SOURCE"

insheet using "criminal_justice.csv"
cd "../csp2017_DTA"
saveold criminal_justice.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "demographic.csv"
cd "../csp2017_DTA"
saveold demographic.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "econ_fiscal.csv"
cd "../csp2017_DTA"
saveold econ_fiscal.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "education.csv"
cd "../csp2017_DTA"
saveold education.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "election.csv"
cd "../csp2017_DTA"
saveold election.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "energy_environment.csv"
cd "../csp2017_DTA"
saveold energy_environment.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "government.csv"
cd "../csp2017_DTA"
saveold government.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "health.csv"
cd "../csp2017_DTA"
saveold health.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "interest_group.csv"
cd "../csp2017_DTA"
saveold interest_group.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "labor.csv"
cd "../csp2017_DTA"
saveold labor.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "licensing.csv"
cd "../csp2017_DTA"
saveold licensing.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "op_part_ideol.csv"
cd "../csp2017_DTA"
saveold op_part_ideol.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "policy_outputs.csv"
cd "../csp2017_DTA"
saveold policy_outputs.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "smoking.csv"
cd "../csp2017_DTA"
saveold smoking.dta,replace
cd "../csp2017_SOURCE"
clear

insheet using "transport.csv"
cd "../csp2017_DTA"

//////////////////////
// Import and merge together these DTA files
//////////////////////
merge 1:1 year state using criminal_justice.dta
drop _merge
merge 1:1 year state using demographic.dta
drop _merge
merge 1:1 year state using econ_fiscal.dta
drop _merge
merge 1:1 year state using education.dta
drop _merge
merge 1:1 year state using energy_environment.dta
drop _merge
merge 1:1 year state using government.dta
drop _merge
merge 1:1 year state using health.dta
drop _merge
merge 1:1 year state using interest_group.dta
drop _merge
merge 1:1 year state using labor.dta
drop _merge
merge 1:1 year state using licensing.dta
drop _merge
merge 1:1 year state using op_part_ideol.dta
drop _merge
merge 1:1 year state using policy_outputs.dta
drop _merge
merge 1:1 year state using smoking.dta
drop _merge

////////////////////
// Write out a master version
////////////////////
cd "../"
saveold "csp2017.dta",replace

///////////////////
// Import govparty_b from CSP v2_1
///////////////////
clear
cd "csp2017_SOURCE"
insheet using "correlatesofstatepolicyprojectv2_1.csv"
keep year st govparty_b
rename govparty_b govbORIG
cd "../"
saveold "csp2014.dta",replace
clear

////////////////////
// Update that csp file
////////////////////
use csp2017.dta
merge 1:1 st year using csp2014.dta
replace govparty_b=govbORIG if govparty_b==.
drop _merge govbORIG
saveold "csp2017.dta",replace

///////////////////
// Update with policy innovation SPID data
///////////////////
cd "pol_innov"
merge 1:1 state year using SPIDv1.dta
drop _merge

//////////////////
// Update with policy liberalism
//////////////////
cd "../"
tostring year,gen(year2)
merge 1:1 st year2 using caughey_warshaw_clean.dta //stpo and year to strings, new vars = st and year2
drop year2 stpo //year2 and stpo from original caughey_warshaw data not needed, they're factor vars.
drop if _merge==2

// Fin
cd "../SCRIPTS"

///////////////////