/////////////////////////////////////////////////////
///////////// Merge in new and updated variables
///
/////// caughey_warshaw variables
/////// nonwhite pop_upd, gsp_upd, pc_inc_upd, citi6013_upd
/////////////////////////////////////////////////////
cd "../../SOURCE"

tostring year,gen(year2) // Need this for merging

// caughey/warshaw
drop _merge
merge 1:1 st year2 using caughey_warshaw_clean.dta //stpo and year to strings, new vars = state and year2
drop year2 stpo //year2 and stpo from original caughey_warshaw data not needed, they're factor vars.
drop if _merge==2

// updates to CSP
drop _merge
cd "updated_csp/"
gen year2=year
tostring year,replace
merge 1:1 state year using CSPupdates.dta
drop year
gen year=year2
drop year2
drop if _merge==2

// Convert updates to numeric
destring gspUPDmil,replace force
destring pi1000sUPD,replace force
destring popUPD,replace force
destring nonwhiteUPD,replace force

drop _merge

// Merge in 2019 NetLib updates
cd "../2019_NetLib_new"
merge 1:1 state year using 2019netlib.dta

//////////////////
// Finalize the variables
//////////////////

// Fill in the OLD variables with new data
replace citi6013=citiUPD if citi6013==.
replace gsp_q=gspUPDmil if gsp_q==.
replace pop_annual=popUPD if pop_annual==.
replace nonwhite=nonwhiteUPD if nonwhite==.

// Create per capita income, updated
gen pc_inc_UPD=pi1000sUPD*1000/popUPD
replace pc_inc_ann=pc_inc_UPD if pc_inc_ann==.

//////////////////////////
///////////////////////////
