/////////////////////////////////////////////////////
///////////// Generate Variables
/////////////////////////////////////////////////////

encode st, gen(stated)
xtset stated year

// gen south dummy variable
gen south =0
replace south =1 if region ==1

//////////////
// Correct a variable that needs updating
//////////////
drop total_expenditure_gsp
gen total_expenditure_gsp= (total_expenditure/(gsp_q*1000))*100

///////////
// Transformations
///////////
gen lnGSP = log(gsp_q)
gen LlnGSP = l.lnGSP
gen lnTotalRevenue = log(total_revenue)
gen lnTaxes = log(taxes)
gen lnTotalExpenditure = log(total_expenditure)
gen LlnTotalRevenue = l.lnTotalRevenue
gen LlnTaxes = l.lnTaxes
gen LlnTotalExpenditure = l.lnTotalExpenditure
gen lnBudgetSurplus = log(budget_surplus)
gen LlnBudgetSurplus = l.lnBudgetSurplus
gen ln_innovate=log(polinnov_sm_upd+0.01)
gen ln_pcincome=log(pc_inc_ann)
gen lnPop = log(pop_annual)
gen LlnPopulation = l.lnPop

////////////
////// Count of chambers controlled 
////////////

//// WITH HALVES

// leg

gen dem_legchambers_halves =.
replace dem_legchambers_halves =0 if leg_cont == 0
replace dem_legchambers_halves =0.5 if leg_cont == 0.25
replace dem_legchambers_halves =1 if leg_cont == 0.5
replace dem_legchambers_halves =1.5 if leg_cont == 0.75
replace dem_legchambers_halves =2 if leg_cont == 1

gen rep_legchambers_halves =.
replace rep_legchambers_halves =0 if leg_cont == 1
replace rep_legchambers_halves =0.5 if leg_cont == 0.75
replace rep_legchambers_halves =1 if leg_cont == 0.5
replace rep_legchambers_halves =1.5 if leg_cont == .25
replace rep_legchambers_halves =2 if leg_cont == 0

// gov

gen dem_gov =.
replace dem_gov =1 if govparty_b==1
replace dem_gov =0 if govparty_b==0
gen rep_gov =.
replace rep_gov =1 if govparty_b==0
replace rep_gov =0 if govparty_b==1

// totals

gen dem_chambers_halves = dem_legchambers_halves + dem_gov if !missing(dem_gov) & !missing(dem_legchambers_halves)
gen rep_chambers_halves = rep_legchambers_halves + rep_gov if !missing(rep_gov) & !missing(rep_legchambers_halves)


//// WITHOUT HALVES

// leg

gen dem_legchambers =.
replace dem_legchambers =0 if leg_cont == 0
replace dem_legchambers =1 if leg_cont == 0.5
replace dem_legchambers =1 if leg_cont == 0.75
replace dem_legchambers =2 if leg_cont == 1

gen rep_legchambers = .
replace rep_legchambers =0 if leg_cont == 1
replace rep_legchambers =1 if leg_cont == 0.5
replace rep_legchambers =1 if leg_cont == .25
replace rep_legchambers =2 if leg_cont == 0

// totals

gen dem_chambers = dem_legchambers + dem_gov if !missing(dem_gov) & !missing(dem_legchambers)
gen rep_chambers = rep_legchambers + rep_gov if !missing(rep_gov) & !missing(rep_legchambers)

//////////////////////
// Change variables
//	Re-codes dem and rep change to collapse +/- 3
//////////////////////

gen dem_change = dem_chambers - dem_chambers[_n-1]
gen rep_change = rep_chambers - rep_chambers[_n-1]
recode dem_change -3=-2 3=2
recode rep_change -3=-2 3=2
gen dem_change2=dem_change*dem_change
gen dem_change3=dem_change*dem_change*dem_change
gen rep_change2=rep_change*rep_change
gen rep_change3=rep_change*rep_change*rep_change

gen dem_leg_change = dem_legchambers - dem_legchambers[_n-1]
gen rep_leg_change = rep_legchambers - rep_legchambers[_n-1]
gen dem_gov_change = dem_gov - dem_gov[_n-1]
gen rep_gov_change = rep_gov - rep_gov[_n-1]

gen dem_change_seatshare_sen = sen_dem_prop_all-sen_dem_prop_all[_n-1]
gen dem_change_seatshare_hs = hs_dem_prop_all-hs_dem_prop_all[_n-1]
gen rep_change_seatshare_sen = sen_rep_prop_all-sen_dem_prop_all[_n-1]
gen rep_change_seatshare_hs = hs_rep_prop_all-hs_rep_prop_all[_n-1]

gen rev_change = total_revenue_gsp - total_revenue_gsp[_n-1]
gen expend_change = total_expenditure_gsp - total_expenditure_gsp[_n-1]
gen surplus_change = budget_surplus_gsp - budget_surplus_gsp[_n-1]
gen lib_change = pollib_median - pollib_median[_n-1]
gen SocLib_change=policysociallib_est - policysociallib_est[_n-1]
gen EconLib_change=policyeconlib_est - policyeconlib_est[_n-1]
gen MassSocLib_change=masssociallib_est - masssociallib_est[_n-1]
gen MassEconLib_change=masseconlib_est - masseconlib_est[_n-1]

gen z_edexp_per_pup_change=z_education_expenditures_per_pup-z_education_expenditures_per_pup[_n-1]
gen citi6013_change=citi6013-citi6013[_n-1]
gen pc_inc_ann_change=pc_inc_ann-pc_inc_ann[_n-1]
gen gsp_change = gsp_q - gsp_q[_n-1]
gen pop_change = pop_annual - pop_annual[_n-1]
gen ln_pc_inc_change=log(pc_inc_ann_change)
gen ln_gsp_change=log(gsp_change)
gen innov_change= polinnov_sm_upd-polinnov_sm_upd[_n-1]
gen ln_innov_change=log(innov_change)
gen ln_pop_change = log(pop_change)

gen LibPolicyChange=LibPolicy-LibPolicy[_n-1]
gen ConsPolicyChange=ConsPolicy-ConsPolicy[_n-1]
gen LibPolicyUpdChange=LibPolicyUpd-LibPolicyUpd[_n-1]
gen ConsPolicyUpdChange=ConsPolicyUpd-ConsPolicyUpd[_n-1]
gen LibPolicyPossChange=LibPolicyPoss-LibPolicyPoss[_n-1]
gen ConsPolicyPossChange=ConsPolicyPoss-ConsPolicyPoss[_n-1]
gen LibPolicyConvChange=LibPolicyConv-LibPolicyConv[_n-1]
gen ConsPolicyConvChange=ConsPolicyConv-ConsPolicyConv[_n-1]
gen NetLibPolUpdChange=NetLibPolUpd-NetLibPolUpd[_n-1]
gen NetLibPolConvChange=NetLibPolConv-NetLibPolConv[_n-1]

gen LibGrumbChange=LibGrumb-LibGrumb[_n-1]
gen ConsGrumbChange=ConsGrumb-ConsGrumb[_n-1]
gen NetLibGrumbChange=NetLibGrumb-NetLibGrumb[_n-1]

gen LibGrsmanChange=LibPolicyGrsman-LibPolicyGrsman[_n-1]
gen ConsGrsmanChange=ConsPolicyGrsman-ConsPolicyGrsman[_n-1]
gen NetLibGrsmanChange=NetLibPolGrsman-NetLibPolGrsman[_n-1]
gen LibGrsmanNCChange=LibPolNCGrsman-LibPolNCGrsman[_n-1]
gen ConsGrsmanNCChange=ConsPolNCGrsman-ConsPolNCGrsman[_n-1]
gen NetLibGrsmanNCChange=NetLibPolNCGrsman-NetLibPolNCGrsman[_n-1]

gen AbortionGrumbChange=AbortionGrumb-AbortionGrumb[_n-1]
gen CivRightsGrumbChange=CivRightsGrumb-CivRightsGrumb[_n-1]
gen CrimJustGrumbChange=CrimJustGrumb-CrimJustGrumb[_n-1]
gen EducGrumbChange= EducGrumb-EducGrumb[_n-1]
gen EnvGrumbChange= EnvGrumb-EnvGrumb[_n-1]
gen GunControlGrumbChange=GunControlGrumb-GunControlGrumb[_n-1]
gen HealthWelfGrumbChange=HealthWelfGrumb-HealthWelfGrumb[_n-1]
gen HousTransMiscGrumbChange= HousTransMiscGrumb-HousTransMiscGrumb[_n-1]
gen ImmigGrumbChange= ImmigGrumb-ImmigGrumb[_n-1]
gen LaborGrumbChange=LaborGrumb-LaborGrumb[_n-1]
gen LGBTGrumbChange= LGBTGrumb-LGBTGrumb[_n-1]
gen MarijGrumbChange= MarijGrumb-MarijGrumb[_n-1]
gen TaxGrumbChange= TaxGrumb-TaxGrumb[_n-1]
gen PubSecLaborGrumbChange= PubSecLaborGrumb-PubSecLaborGrumb[_n-1]
gen VotingGrumbChange=VotingGrumb-VotingGrumb[_n-1]

gen LibNikSizeScopeChange= LibPolNikSizeScope-LibPolNikSizeScope[_n-1]
gen ConsNikSizeScopeChange= ConsPolNikSizeScope-ConsPolNikSizeScope[_n-1]
gen NetLibNikSizeScopeChange= NetLibNikSizeScope-NetLibNikSizeScope[_n-1]

gen LibPolNikConvChange=LibPolicyNikConv-LibPolicyNikConv[_n-1]
gen ConsPolNikConvChange=ConsPolicyNikConv-ConsPolicyNikConv[_n-1]
gen NetLibNikConvChange=NetLibPolNikConv-NetLibPolNikConv[_n-1]

gen LibPolNikBoehmMEChange=LibPolicyNikBoehmME-LibPolicyNikBoehmME[_n-1]
gen ConsPolNikBoehmMEChange=ConsPolicyNikBoehmME-ConsPolicyNikBoehmME[_n-1]
gen NetLibNikBoehmMEChange=NetLibPolNikBoehmME-NetLibPolNikBoehmME[_n-1]

gen LibPolNikBoehmFDChange=LibPolicyNikBoehmFD-LibPolicyNikBoehmFD[_n-1]
gen ConsPolNikBoehmFDChange=ConsPolicyNikBoehmFD-ConsPolicyNikBoehmFD[_n-1]
gen NetLibNikBoehmFDChange=NetLibPolNikBoehmFD-NetLibPolNikBoehmFD[_n-1]

gen LibPolNikGrumbChange=LibPolicyNikGrumb-LibPolicyNikGrumb[_n-1]
gen ConsPolNikGrumbChange=ConsPolicyNikGrumb-ConsPolicyNikGrumb[_n-1]
gen NetLibNikGrumbChange=NetLibPolNikGrumb-NetLibPolNikGrumb[_n-1]

gen LibSize19change=liberalsize-liberalsize[_n-1]
gen ConsSize19change=conservsize-conservsize[_n-1]
gen NetLibSize19change=netlibsize-netlibsize[_n-1]
gen LibConv19change=liberalcoal-liberalcoal[_n-1]
gen ConsConv19change=conservcoal-conservcoal[_n-1]
gen NetLibConv19change=netlibcoal-netlibcoal[_n-1]

///////////////
// binary DV
///////////////
gen towards_dem = 0
replace towards_dem = 1 if dem_chambers - dem_chambers[_n-1] >0

gen towards_rep = 0
replace towards_rep = 1 if rep_chambers - rep_chambers[_n-1] >0


////////////////
///// Dummies for chambers
////////////////
gen rep_atleast_one =.
replace rep_atleast_one = 0 if rep_chambers ==0
replace rep_atleast_one = 1 if rep_chambers >=1

gen rep_atleast_two =.
replace rep_atleast_two = 0 if rep_chambers <2
replace rep_atleast_two = 1 if rep_chambers >=2

gen rep_atleast_three =.
replace rep_atleast_three = 0 if rep_chambers <3
replace rep_atleast_three = 1 if rep_chambers >=3

gen dem_atleast_one =.
replace dem_atleast_one = 0 if dem_chambers ==0
replace dem_atleast_one = 1 if dem_chambers >=1

gen dem_atleast_two =.
replace dem_atleast_two = 0 if dem_chambers <2
replace dem_atleast_two = 1 if dem_chambers >=2

gen dem_atleast_three =.
replace dem_atleast_three = 0 if dem_chambers <3
replace dem_atleast_three = 1 if dem_chambers >=3

///////////
// Factor variables
///////////
gen rep_change_factor=rep_change+2
gen dem_change_factor=dem_change+2
label define changelabel 0 "Loss 2+" 1 "Loss 1" 2 "No Change" 3 "Gain 1" 4 "Gain 2+"
label values rep_change_factor changelabel
label values dem_change_factor changelabel

gen rep_leg_change_factor=rep_leg_change+2
gen dem_leg_change_factor=dem_leg_change+2
label define changelabel2 0 "Loss 2" 1 "Loss 1" 2 "No Change" 3 "Gain 1" 4 "Gain 2"
label values rep_leg_change_factor changelabel2
label values dem_leg_change_factor changelabel2

gen rep_gov_change_factor=rep_gov_change+1
gen dem_gov_change_factor=dem_gov_change+1
label define changelabel3 0 "Loss" 1 "No Change" 2 "Gain" 
label values rep_gov_change_factor changelabel3
label values dem_gov_change_factor changelabel3

//////////
// Lagged variables
//////////
gen Lrep_atleast_one=l.rep_atleast_one
gen Lrep_atleast_two=l.rep_atleast_two
gen Ldem_atleast_one=l.dem_atleast_one
gen Ldem_atleast_two=l.dem_atleast_two

gen Lrep_chambers=l.rep_chambers
gen Ldem_chambers=l.dem_chambers
gen Ldem_gov=l.dem_gov
gen Lrep_gov=l.rep_gov
gen Ldem_legchambers=l.dem_legchambers
gen Lrep_legchambers=l.rep_legchambers

gen Lpollib_median=l.pollib_median
gen Ltotal_exp_gsp=l.total_expenditure_gsp
gen Linnovation=l.polinnov_sm_upd
gen Lln_innovate=l.ln_innovate

gen LLibPolicy=l.LibPolicy
gen LConsPolicy=l.ConsPolicy
gen LLibPolicyUpd=l.LibPolicyUpd
gen LConsPolicyUpd=l.ConsPolicyUpd
gen LLibPolicyPoss=l.LibPolicyPoss
gen LConsPolicyPoss=l.ConsPolicyPoss
gen LLibPolicyConv=l.LibPolicyConv
gen LConsPolicyConv=l.ConsPolicyConv

///////////////////////////////////////////