//This file generates three counts of how many policies
// are in place per year defined as liberal or conservative.
// There are variables which capture gradations of those Im sure of,
// those Im less sure of but have made a reasonable guess, 
// and those for which I could see it going either way.
// In the final category, I simply try it both ways.
//
//Variables are ONLY binary variables.
//
//I comment out those not within the 1989-2014 time frame.
//////////
//Liberal (62 policies)
gen LibPolicy = 0
replace LibPolicy = LibPolicy + abortion_consent_1973_1991 if  abortion_consent_1973_1991 != .
replace LibPolicy = LibPolicy + abortion_consent_1992_2014  if  abortion_consent_1992_2014  != .
replace LibPolicy = LibPolicy + abortion_medicaid if  abortion_medicaid != .
//replace LibPolicy = LibPolicy + abortion_partial_birth if  abortion_partial_birth != .
//replace LibPolicy = LibPolicy + boehmke_snrpresc if  boehmke_snrpresc != .
replace LibPolicy = LibPolicy + cig_taxes_biry if  cig_taxes_biry != .
replace LibPolicy = LibPolicy + corporate_incometax if  corporate_incometax != .
//replace LibPolicy = LibPolicy + drugs_boehmke_kegreg if  drugs_boehmke_kegreg != .
replace LibPolicy = LibPolicy + drugs_boehmke_mlda21 if  drugs_boehmke_mlda21 != .
//replace LibPolicy = LibPolicy + drugs_boehmke_zerotol if  drugs_boehmke_zerotol != .
replace LibPolicy = LibPolicy + drugs_marijua_decrimilization if  drugs_marijua_decrimilization != .
//replace LibPolicy = LibPolicy + drugs_smoking_ban_restaurants if  drugs_smoking_ban_restaurants != .
//replace LibPolicy = LibPolicy + drugs_smoking_ban_workplaces if  drugs_smoking_ban_workplaces != .
replace LibPolicy = LibPolicy + education_corporal_punishment_ba if  education_corporal_punishment_ba != .
replace LibPolicy = LibPolicy + education_librarysystem if  education_librarysystem != .
replace LibPolicy = LibPolicy + environment_air_pollution_contro if  environment_air_pollution_contro != .
replace LibPolicy = LibPolicy + environment_bottlebill if  environment_bottlebill != .
//replace LibPolicy = LibPolicy + environment_ca_car_emissions_sta if  environment_ca_car_emissions_sta != .
//replace LibPolicy = LibPolicy + environment_electronic_waste if  environment_electronic_waste != .
//replace LibPolicy = LibPolicy + environment_ghg_cap if  environment_ghg_cap != .
//replace LibPolicy = LibPolicy + environment_publicbenefit_funds if  environment_publicbenefit_funds != .
replace LibPolicy = LibPolicy + environment_state_nepas if  environment_state_nepas != .
//replace LibPolicy = LibPolicy + estate_tax if  estate_tax != .
//replace LibPolicy = LibPolicy + gayrights_ban_sodomy if  gayrights_ban_sodomy != .
//replace LibPolicy = LibPolicy + gayrights_hatecrimes if  gayrights_hatecrimes != .
replace LibPolicy = LibPolicy + genderrights_gender_discrimition if  genderrights_gender_discrimition != .
replace LibPolicy = LibPolicy + genderrights_gender_equal_pay if  genderrights_gender_equal_pay != .
replace LibPolicy = LibPolicy + genderrights_state_eras if  genderrights_state_eras != .
replace LibPolicy = LibPolicy + guncontrol_assaultweapon_ban if  guncontrol_assaultweapon_ban != .
replace LibPolicy = LibPolicy + guncontrol_licenses_dealers if  guncontrol_licenses_dealers != .
//replace LibPolicy = LibPolicy + guncontrol_satnightspecial_ban if  guncontrol_satnightspecial_ban != .
replace LibPolicy = LibPolicy + income_taxes if  income_taxes != .
//replace LibPolicy = LibPolicy + labor_age_discrimition if  labor_age_discrimition != .
replace LibPolicy = LibPolicy + labor_minimumwage_men if  labor_minimumwage_men != .
replace LibPolicy = LibPolicy + labor_minimumwage_women_anymajor if  labor_minimumwage_women_anymajor != .
//replace LibPolicy = LibPolicy + labor_minwage_abovefed if  labor_minwage_abovefed != .
replace LibPolicy = LibPolicy + labor_prevailing_wage_laws if  labor_prevailing_wage_laws != .
replace LibPolicy = LibPolicy + labor_state_disability_insurance if  labor_state_disability_insurance != .
replace LibPolicy = LibPolicy + labor_state_retirement_system if  labor_state_retirement_system != .
replace LibPolicy = LibPolicy + labor_workers_compensation if  labor_workers_compensation != .
replace LibPolicy = LibPolicy + licenses_accountants if  licenses_accountants != .
replace LibPolicy = LibPolicy + licenses_architects if  licenses_architects != .
replace LibPolicy = LibPolicy + licenses_beauticians if  licenses_beauticians != .
replace LibPolicy = LibPolicy + licenses_chiropractors if  licenses_chiropractors != .
replace LibPolicy = LibPolicy + licenses_dentists if  licenses_dentists != .
replace LibPolicy = LibPolicy + licenses_engineers if  licenses_engineers != .
replace LibPolicy = LibPolicy + licenses_nurses if  licenses_nurses != .
replace LibPolicy = LibPolicy + licenses_pharmacists if  licenses_pharmacists != .
replace LibPolicy = LibPolicy + licenses_real_estate if  licenses_real_estate != .
replace LibPolicy = LibPolicy + medicaid_stateadoption if  medicaid_stateadoption != .
replace LibPolicy = LibPolicy + race_boehmke_fhpub if  race_boehmke_fhpub != .
replace LibPolicy = LibPolicy + race_fair_employment_commissions if  race_fair_employment_commissions != .
replace LibPolicy = LibPolicy + race_fair_employ_comm_post1964 if  race_fair_employ_comm_post1964 != .
replace LibPolicy = LibPolicy + race_interracial_marriage_banned if  race_interracial_marriage_banned != .
replace LibPolicy = LibPolicy + race_school_segregation if  race_school_segregation != .
replace LibPolicy = LibPolicy + regulation_bicycle_helmets if  regulation_bicycle_helmets != .
replace LibPolicy = LibPolicy + regulation_boehmke_grandvist if  regulation_boehmke_grandvist != .
//replace LibPolicy = LibPolicy + regulation_boehmke_shield if  regulation_boehmke_shield != .
replace LibPolicy = LibPolicy + regulation_forced_sterlizations if  regulation_forced_sterlizations != .
replace LibPolicy = LibPolicy + regulation_hate_crimes if  regulation_hate_crimes != .
replace LibPolicy = LibPolicy + regulation_housing_directstateai if  regulation_housing_directstateai != .
replace LibPolicy = LibPolicy + regulation_housing_ebling_federa if  regulation_housing_ebling_federa != .
replace LibPolicy = LibPolicy + regulation_mandatory_car_insuran if  regulation_mandatory_car_insuran != .
replace LibPolicy = LibPolicy + regulation_mandatory_seatbelts if  regulation_mandatory_seatbelts != .
replace LibPolicy = LibPolicy + regulation_motorcycle_helmets if  regulation_motorcycle_helmets != .
replace LibPolicy = LibPolicy + regulation_pain_suffering_limits if  regulation_pain_suffering_limits != .
replace LibPolicy = LibPolicy + regulation_sedition_laws if  regulation_sedition_laws != .
replace LibPolicy = LibPolicy + regulation_utility_jurisdiction if  regulation_utility_jurisdiction != .
replace LibPolicy = LibPolicy + regulations_lemonlaw if  regulations_lemonlaw != .
replace LibPolicy = LibPolicy + sales_taxes_biry_pre1946 if  sales_taxes_biry_pre1946 != .
replace LibPolicy = LibPolicy + w_abortion_parental_notice_1983_ if  w_abortion_parental_notice_1983_ != .
replace LibPolicy = LibPolicy + w_animal_cruelty_felony if  w_animal_cruelty_felony != .
replace LibPolicy = LibPolicy + w_education_moment_of_silence if  w_education_moment_of_silence != .
replace LibPolicy = LibPolicy + w_environment_endangered_species if  w_environment_endangered_species != .
replace LibPolicy = LibPolicy + w_environment_solar_taxcredit if  w_environment_solar_taxcredit != .
replace LibPolicy = LibPolicy + w_gayrights_employment_discrimit if  w_gayrights_employment_discrimit != .
replace LibPolicy = LibPolicy + w_gayrights_public_accomodations if  w_gayrights_public_accomodations != .
//replace LibPolicy = LibPolicy + w_labor_state_ada if  w_labor_state_ada != .
//replace LibPolicy = LibPolicy + w_race_disc_public_accommodation if  w_race_disc_public_accommodation != .
replace LibPolicy = LibPolicy + w_race_disc_public_accom2 if  w_race_disc_public_accom2 != .
replace LibPolicy = LibPolicy + w_race_fair_housing_private if  w_race_fair_housing_private != .
replace LibPolicy = LibPolicy + x_labor_childlabor_workpermitage if  x_labor_childlabor_workpermitage != .
//Conservative (8 policies)
gen ConsPolicy = 0
replace ConsPolicy = ConsPolicy + abortion_reform_preroe if  abortion_reform_preroe != .
replace ConsPolicy = ConsPolicy + death_penalty if  death_penalty != .
//replace ConsPolicy = ConsPolicy + drugs_medical_marijua if  drugs_medical_marijua != .
//replace ConsPolicy = ConsPolicy + gambling_casinos if  gambling_casinos != .
replace ConsPolicy = ConsPolicy + genderrights_jury_service if  genderrights_jury_service != .
replace ConsPolicy = ConsPolicy + genderrights_nofault_divorce if  genderrights_nofault_divorce != .
replace ConsPolicy = ConsPolicy + regulation_physician_suicide if  regulation_physician_suicide != .
replace ConsPolicy = ConsPolicy + regulations_state_debt_limitatio if  regulations_state_debt_limitatio != .
replace ConsPolicy = ConsPolicy + w_ec_access if  w_ec_access != .
//replace ConsPolicy = ConsPolicy + w_education_biblereading if  w_education_biblereading != .
//replace ConsPolicy = ConsPolicy + w_gayrights_civilunions_marriage if  w_gayrights_civilunions_marriage != .
//LibPolicyUpd (+11 policies)
gen LibPolicyUpd = LibPolicy
//replace LibPolicyUpd = LibPolicyUpd + drugs_boehmke_statrapage if  drugs_boehmke_statrapage != .
replace LibPolicyUpd = LibPolicyUpd + earned_income_taxcredit if  earned_income_taxcredit != .
replace LibPolicyUpd = LibPolicyUpd + education_schoolfordeaf if  education_schoolfordeaf != .
replace LibPolicyUpd = LibPolicyUpd + gambling_lottery_adoption if  gambling_lottery_adoption != .
replace LibPolicyUpd = LibPolicyUpd + genderrights_era_ratification if  genderrights_era_ratification != .
replace LibPolicyUpd = LibPolicyUpd + immigration_english_language if  immigration_english_language != .
replace LibPolicyUpd = LibPolicyUpd + labor_merit_system if  labor_merit_system != .
replace LibPolicyUpd = LibPolicyUpd + labor_right_to_work if  labor_right_to_work != .
replace LibPolicyUpd = LibPolicyUpd + race_boehmke_fhurb if  race_boehmke_fhurb != .
//replace LibPolicyUpd = LibPolicyUpd + regulation_boehmke_cogrowman if  regulation_boehmke_cogrowman != .
replace LibPolicyUpd = LibPolicyUpd + transportation_controlledaccessh if  transportation_controlledaccessh != .
replace LibPolicyUpd = LibPolicyUpd + w_labor_relations_acts if  w_labor_relations_acts != .
//ConsPolicyUpd (+3 policies)
gen ConsPolicyUpd = ConsPolicy
//replace ConsPolicyUpd = ConsPolicyUpd + labor_collective_bargaining_stat if  labor_collective_bargaining_stat != .
//replace ConsPolicyUpd = ConsPolicyUpd + labor_collective_bargaining_teac if  labor_collective_bargaining_teac != .
replace ConsPolicyUpd = ConsPolicyUpd + regulation_boehmke_livingwill if  regulation_boehmke_livingwill != .
replace ConsPolicyUpd = ConsPolicyUpd + regulation_rent_control if  regulation_rent_control != .
//replace ConsPolicyUpd = ConsPolicyUpd + regulation_rfra if  regulation_rfra != .
//LibPolicyPoss
gen LibPolicyPoss = LibPolicyUpd
replace LibPolicyPoss = LibPolicyUpd + guncontrol_opencarry if  guncontrol_opencarry != .
//replace LibPolicyPoss = LibPolicyUpd + guncontrol_stand_your_ground if  guncontrol_stand_your_ground != .
replace LibPolicyPoss = LibPolicyUpd + labor_antiinjunction_laws if  labor_antiinjunction_laws != .
replace LibPolicyPoss = LibPolicyUpd + regulations_homerule if  regulations_homerule != .
//ConsPolicyPoss
gen ConsPolicyPoss = ConsPolicyUpd
replace ConsPolicyPoss = ConsPolicyUpd + guncontrol_opencarry if  guncontrol_opencarry != .
//replace ConsPolicyPoss = ConsPolicyUpd + guncontrol_stand_your_ground if  guncontrol_stand_your_ground != .
replace ConsPolicyPoss = ConsPolicyUpd + labor_antiinjunction_laws if  labor_antiinjunction_laws != .
replace ConsPolicyPoss = ConsPolicyUpd + regulations_homerule if  regulations_homerule != .
///////////////////////////
// Conventional definition of liberal/conservative
///////////////////////////
gen LibPolicyConv=LibPolicyUpd
gen ConsPolicyConv=ConsPolicyUpd
//Remove conventionally conservative policies from the liberal measure (-6 liberal, +5 conservative)
// replace LibPolicyConv = LibPolicyConv - abortion_consent_1973_1991 if  abortion_consent_1973_1991 !=.
// replace LibPolicyConv = LibPolicyConv - abortion_consent_1992_2014 if  abortion_consent_1992_2014 !=.
replace LibPolicyConv = LibPolicyConv - w_abortion_parental_notice_1983_ if  w_abortion_parental_notice_1983_ !=.
// replace LibPolicyConv = LibPolicyConv - abortion_partial_birth if  abortion_partial_birth !=.
replace LibPolicyConv = LibPolicyConv - death_penalty if  death_penalty !=.
// replace LibPolicyConv = LibPolicyConv - w_education_biblereading if  w_education_biblereading !=.
// replace LibPolicyConv = LibPolicyConv - gayrights_ban_sodomy if  gayrights_ban_sodomy !=.
replace LibPolicyConv = LibPolicyConv - labor_right_to_work if  labor_right_to_work !=.
// replace ConsPolicyConv = ConsPolicyConv + abortion_consent_1973_1991 if  abortion_consent_1973_1991 !=.
// replace ConsPolicyConv = ConsPolicyConv + abortion_consent_1992_2014 if  abortion_consent_1992_2014 !=.
replace ConsPolicyConv = ConsPolicyConv + w_abortion_parental_notice_1983_ if  w_abortion_parental_notice_1983_ !=.
// replace ConsPolicyConv = ConsPolicyConv + abortion_partial_birth if  abortion_partial_birth !=.
replace ConsPolicyConv = ConsPolicyConv + death_penalty if  death_penalty !=.
// replace ConsPolicyConv = ConsPolicyConv + w_education_biblereading if  w_education_biblereading !=.
// replace ConsPolicyConv = ConsPolicyConv + gayrights_ban_sodomy if  gayrights_ban_sodomy !=.
replace ConsPolicyConv = ConsPolicyConv + labor_right_to_work if  labor_right_to_work !=.
//Do the other way around (+3 liberal, -3 conservative)
replace LibPolicyConv = LibPolicyConv + abortion_medicaid if  abortion_medicaid !=.
// replace LibPolicyConv = LibPolicyConv + abortion_reform_preroe if  abortion_reform_preroe !=.
replace LibPolicyConv = LibPolicyConv + guncontrol_assaultweapon_ban if  guncontrol_assaultweapon_ban !=.
// replace LibPolicyConv = LibPolicyConv + labor_minwage_abovefed if  labor_minwage_abovefed !=.
// replace LibPolicyConv = LibPolicyConv + w_gayrights_civilunions_marriage if  w_gayrights_civilunions_marriage !=.
replace LibPolicyConv = LibPolicyConv + w_gayrights_employment_discrimit if  w_gayrights_employment_discrimit !=.
replace LibPolicyConv = LibPolicyConv + w_gayrights_public_accomodations if  w_gayrights_public_accomodations !=.
replace ConsPolicyConv = ConsPolicyConv - abortion_medicaid if  abortion_medicaid !=.
// replace ConsPolicyConv = ConsPolicyConv - abortion_reform_preroe if  abortion_reform_preroe !=.
replace ConsPolicyConv = ConsPolicyConv - guncontrol_assaultweapon_ban if  guncontrol_assaultweapon_ban !=.
// replace ConsPolicyConv = ConsPolicyConv - labor_minwage_abovefed if  labor_minwage_abovefed !=.
// replace ConsPolicyConv = ConsPolicyConv - w_gayrights_civilunions_marriage if  w_gayrights_civilunions_marriage !=.
replace ConsPolicyConv = ConsPolicyConv - w_gayrights_employment_discrimit if  w_gayrights_employment_discrimit !=.
replace ConsPolicyConv = ConsPolicyConv - w_gayrights_public_accomodations if  w_gayrights_public_accomodations !=.
////////////////////////////
// Net Liberal
////////////////////////////
gen NetLibPolConv=LibPolicyConv-ConsPolicyConv
gen NetLibPolUpd=LibPolicyUpd-ConsPolicyUpd

///////////////////////////////////////////