//This file generates three counts of how many policies
// are in place per year defined as liberal or conservative.
// There are variables which capture gradations of those Im sure of,
// those Im less sure of but have made a reasonable guess, 
// and those for which I could see it going either way.
// In the final category, I simply try it both ways.
//
//Variables are ONLY binary variables.
//
//I comment out those not within the 1989-2014 time frame.
//////////
//////////////////
//Directionality: lib/cons
//////////////////
gen LibGrumb=0
gen ConsGrumb=0
////////////
//Categories: total yearly net liberal by policy
////////////
gen AbortionGrumb=0
gen CampFinGrumb=0 //None
gen CivRightsGrumb=0
gen CrimJustGrumb=0
gen EducGrumb=0
gen EnvGrumb=0
gen GunControlGrumb=0
gen HealthWelfGrumb=0
gen HousTransMiscGrumb=0
gen ImmigGrumb=0
gen LaborGrumb=0
gen LGBTGrumb=0
gen MarijGrumb=0
gen TaxGrumb=0
gen PubSecLaborGrumb=0
gen VotingGrumb=0
/////////////////
//Categorization
/////////////////
//Abortion
replace ConsGrumb = ConsGrumb + abortion_consent_1973_1991 if  abortion_consent_1973_1991 != .
replace AbortionGrumb=AbortionGrumb-abortion_consent_1973_1991 if  abortion_consent_1973_1991 != .
replace ConsGrumb = ConsGrumb + abortion_consent_1992_2014  if  abortion_consent_1992_2014  != .
replace AbortionGrumb=AbortionGrumb-abortion_consent_1992_2014 if  abortion_consent_1992_2014 != .
replace LibGrumb = LibGrumb + abortion_medicaid if  abortion_medicaid != .
replace AbortionGrumb=AbortionGrumb+abortion_medicaid if  abortion_medicaid != .
replace ConsGrumb = ConsGrumb + abortion_partial_birth if  abortion_partial_birth != .
replace AbortionGrumb=AbortionGrumb-abortion_partial_birth if  abortion_partial_birth != .
replace ConsGrumb = ConsGrumb + w_abortion_parental_notice_1983_ if  w_abortion_parental_notice_1983_ != .
replace AbortionGrumb=AbortionGrumb-w_abortion_parental_notice_1983_ if  w_abortion_parental_notice_1983_ != .
replace LibGrumb = LibGrumb + w_ec_access if  w_ec_access != .
replace AbortionGrumb=AbortionGrumb+w_ec_access if  w_ec_access != .
//Civil rights
replace LibGrumb = LibGrumb + education_corporal_punishment_ba if  education_corporal_punishment_ba != .
replace LibGrumb = LibGrumb + genderrights_era_ratification if  genderrights_era_ratification != .
replace LibGrumb = LibGrumb + genderrights_gender_discrimition if  genderrights_gender_discrimition != .
replace LibGrumb = LibGrumb + genderrights_gender_equal_pay if  genderrights_gender_equal_pay != .
replace LibGrumb = LibGrumb + genderrights_nofault_divorce if  genderrights_nofault_divorce != .
replace LibGrumb = LibGrumb + genderrights_state_eras if  genderrights_state_eras != .
//replace LibGrumb = LibGrumb + genderrights_gender_discrimination_laws if  genderrights_gender_discrimination_laws != .
replace LibGrumb = LibGrumb + pubbrefeed if  pubbrefeed != .
replace LibGrumb = LibGrumb + race_fair_employ_comm_post1964 if  race_fair_employ_comm_post1964 != .
replace ConsGrumb = ConsGrumb + regulation_physician_suicide if  regulation_physician_suicide != .
replace ConsGrumb = ConsGrumb + regulation_rfra if  regulation_rfra != .
replace LibGrumb = LibGrumb + shield if  shield != .
gen w_biblereadingNorm=w_education_biblereading
replace w_biblereadingNorm=1 if w_biblereadingNorm==2
replace ConsGrumb = ConsGrumb + w_biblereadingNorm if  w_biblereadingNorm != .
gen w_momsilNorm=w_education_moment_of_silence
replace w_momsilNorm=1 if w_momsilNorm==2
replace ConsGrumb = ConsGrumb + w_momsilNorm if  w_momsilNorm != .
gen w_stateadaNorm=w_labor_state_ada
replace w_stateadaNorm=1 if w_stateadaNorm==2
replace LibGrumb = LibGrumb + w_stateadaNorm if  w_stateadaNorm != .
gen w_racediscpubaccNorm=w_race_disc_public_accommodation
replace w_racediscpubaccNorm=1 if w_racediscpubaccNorm==2
replace LibGrumb = LibGrumb + w_racediscpubaccNorm if  w_racediscpubaccNorm != .
replace CivRightsGrumb = CivRightsGrumb + education_corporal_punishment_ba if  education_corporal_punishment_ba != .
replace CivRightsGrumb = CivRightsGrumb + genderrights_era_ratification if  genderrights_era_ratification != .
replace CivRightsGrumb = CivRightsGrumb + genderrights_gender_discrimition if  genderrights_gender_discrimition != .
replace CivRightsGrumb = CivRightsGrumb + genderrights_gender_equal_pay if  genderrights_gender_equal_pay != .
replace CivRightsGrumb = CivRightsGrumb + genderrights_nofault_divorce if  genderrights_nofault_divorce != .
replace CivRightsGrumb = CivRightsGrumb + genderrights_state_eras if  genderrights_state_eras != .
//replace CivRightsGrumb = CivRightsGrumb + genderrights_gender_discrimination_laws if  genderrights_gender_discrimination_laws != .
replace CivRightsGrumb = CivRightsGrumb + pubbrefeed if  pubbrefeed != .
replace CivRightsGrumb = CivRightsGrumb + race_fair_employ_comm_post1964 if  race_fair_employ_comm_post1964 != .
replace CivRightsGrumb = CivRightsGrumb - regulation_physician_suicide if  regulation_physician_suicide != .
replace CivRightsGrumb = CivRightsGrumb - regulation_rfra if  regulation_rfra != .
replace CivRightsGrumb = CivRightsGrumb + shield if  shield != .
replace CivRightsGrumb = CivRightsGrumb - w_biblereadingNorm if  w_biblereadingNorm != .
replace CivRightsGrumb = CivRightsGrumb - w_momsilNorm if  w_momsilNorm != .
replace CivRightsGrumb = CivRightsGrumb + w_stateadaNorm if  w_stateadaNorm != .
replace CivRightsGrumb = CivRightsGrumb + w_racediscpubaccNorm if  w_racediscpubaccNorm != .
//Criminal justice
replace LibGrumb = LibGrumb + death_penalty if  death_penalty != .
replace LibGrumb = LibGrumb + postdna if  postdna != .
replace CrimJustGrumb = CrimJustGrumb + death_penalty if  death_penalty != .
replace CrimJustGrumb = CrimJustGrumb + postdna if  postdna != .
//Education
replace ConsGrumb = ConsGrumb + chartersch if  chartersch != .
replace ConsGrumb = ConsGrumb + schoolchoi if  schoolchoi != .
sum z_education_expenditures_per_pup
gen z_edexpNorm=(z_education_expenditures_per_pup-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + z_edexpNorm if  z_edexpNorm != .
sum z_education_higher_edu_spending
gen z_higheredNorm=(z_education_higher_edu_spending-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + z_higheredNorm if  z_higheredNorm != .
replace EducGrumb = EducGrumb - chartersch if  chartersch != .
replace EducGrumb = EducGrumb - schoolchoi if  schoolchoi != .
replace EducGrumb = EducGrumb + z_edexpNorm if  z_edexpNorm != .
replace EducGrumb = EducGrumb + z_higheredNorm if  z_higheredNorm != .
//Environment
replace LibGrumb = LibGrumb + environment_bottlebill if  environment_bottlebill != .
replace LibGrumb = LibGrumb + environment_ca_car_emissions_sta if  environment_ca_car_emissions_sta != .
replace LibGrumb = LibGrumb + environment_electronic_waste if  environment_electronic_waste != .
replace LibGrumb = LibGrumb + environment_ghg_cap if  environment_ghg_cap != .
replace LibGrumb = LibGrumb + environment_publicbenefit_funds if  environment_publicbenefit_funds != .
replace LibGrumb = LibGrumb + environment_state_nepas if  environment_state_nepas != .
gen w_env_endspecNorm=w_environment_endangered_species
replace w_env_endspecNorm=1 if w_env_endspecNorm==2
replace LibGrumb = LibGrumb + w_env_endspecNorm if  w_env_endspecNorm != .
gen w_env_soltaxcredNorm= w_environment_solar_taxcredit
replace w_env_soltaxcredNorm=1 if w_env_soltaxcredNorm==2
replace LibGrumb = LibGrumb + w_env_soltaxcredNorm if  w_env_soltaxcredNorm != .
replace EnvGrumb = EnvGrumb + environment_bottlebill if  environment_bottlebill != .
replace EnvGrumb = EnvGrumb + environment_ca_car_emissions_sta if  environment_ca_car_emissions_sta != .
replace EnvGrumb = EnvGrumb + environment_electronic_waste if  environment_electronic_waste != .
replace EnvGrumb = EnvGrumb + environment_ghg_cap if  environment_ghg_cap != .
replace EnvGrumb = EnvGrumb + environment_publicbenefit_funds if  environment_publicbenefit_funds != .
replace EnvGrumb = EnvGrumb + environment_state_nepas if  environment_state_nepas != .
replace EnvGrumb = EnvGrumb + w_env_endspecNorm if  w_env_endspecNorm != .
replace EnvGrumb = EnvGrumb + w_env_soltaxcredNorm if  w_env_soltaxcredNorm != .
//Gun Control
replace LibGrumb = LibGrumb + bradycamp if  bradycamp != .
replace LibGrumb = LibGrumb + guncontrol_assaultweapon_ban if  guncontrol_assaultweapon_ban != .
replace LibGrumb = LibGrumb + guncontrol_licenses_dealers if  guncontrol_licenses_dealers != .
replace LibGrumb = LibGrumb + guncontrol_opencarry if  guncontrol_opencarry != .
replace LibGrumb = LibGrumb + guncontrol_satnightspecial_ban if  guncontrol_satnightspecial_ban != .
replace LibGrumb = LibGrumb + guncontrol_stand_your_ground if  guncontrol_stand_your_ground != .
gen w_gun_bcdealNorm= w_guncontrol_bc_dealers
replace w_gun_bcdealNorm=1 if w_gun_bcdealNorm==2
replace LibGrumb = LibGrumb + w_gun_bcdealNorm if  w_gun_bcdealNorm != .
gen w_gun_bcprivNorm= w_guncontrol_bc_privatesales
replace w_gun_bcprivNorm=1 if w_gun_bcprivNorm==2
replace LibGrumb = LibGrumb + w_gun_bcprivNorm if  w_gun_bcprivNorm != .
gen w_gun_regNorm= w_guncontrol_registration_requir
replace w_gun_regNorm=1 if w_gun_regNorm==2
replace LibGrumb = LibGrumb + w_gun_regNorm if  w_gun_regNorm != .
gen w_gun_waitNorm= w_guncontrol_waitingperiod
replace w_gun_waitNorm=1 if w_gun_waitNorm==2
replace LibGrumb = LibGrumb + w_gun_waitNorm if  w_gun_waitNorm != .
replace GunControlGrumb = GunControlGrumb + bradycamp if  bradycamp != .
replace GunControlGrumb = GunControlGrumb + guncontrol_assaultweapon_ban if  guncontrol_assaultweapon_ban != .
replace GunControlGrumb = GunControlGrumb + guncontrol_licenses_dealers if  guncontrol_licenses_dealers != .
replace GunControlGrumb = GunControlGrumb + guncontrol_opencarry if  guncontrol_opencarry != .
replace GunControlGrumb = GunControlGrumb + guncontrol_satnightspecial_ban if  guncontrol_satnightspecial_ban != .
replace GunControlGrumb = GunControlGrumb + guncontrol_stand_your_ground if  guncontrol_stand_your_ground != .
replace GunControlGrumb = GunControlGrumb + w_gun_bcdealNorm if  w_gun_bcdealNorm != .
replace GunControlGrumb = GunControlGrumb + w_gun_bcprivNorm if  w_gun_bcprivNorm != .
replace GunControlGrumb = GunControlGrumb + w_gun_regNorm if  w_gun_regNorm != .
replace GunControlGrumb = GunControlGrumb + w_gun_waitNorm if  w_gun_waitNorm != .
//Health and Welfare 
replace LibGrumb = LibGrumb + afdc_up if  afdc_up != .
replace LibGrumb = LibGrumb + medicaid_stateadoption if  medicaid_stateadoption != .
replace LibGrumb = LibGrumb + sdce if  sdce != .
replace LibGrumb = LibGrumb + snrpresc if  snrpresc != .
replace ConsGrumb = ConsGrumb + timelim if  timelim != .
sum x_chip_children
gen x_chip_childNorm=(x_chip_children-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + x_chip_childNorm if  x_chip_childNorm != .
sum x_chip_infants
gen x_chip_infNorm=(x_chip_infants-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + x_chip_infNorm if  x_chip_infNorm != .
sum x_chip_pregntwomen
gen x_chip_pregNorm=(x_chip_pregntwomen-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + x_chip_pregNorm if  x_chip_pregNorm != .
sum x_chip_pregntwomen_prebba
gen x_chip_pregprebbaNorm=(x_chip_pregntwomen_prebba-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + x_chip_pregprebbaNorm if  x_chip_pregprebbaNorm != .
sum z_ssi_afdc_families_payments
gen z_ssi_afdcfamNorm=(z_ssi_afdc_families_payments-r(min))/(r(max)/r(min))
replace LibGrumb = LibGrumb + z_ssi_afdcfamNorm if  z_ssi_afdcfamNorm != .
sum z_tanf_initialelig
gen z_tanf_initeligNorm=(z_tanf_initialelig-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + z_tanf_initeligNorm if  z_tanf_initeligNorm != .
sum z_tanf_paymentsperfamily
gen z_tanf_payperfamNorm=(z_tanf_paymentsperfamily-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + z_tanf_payperfamNorm if  z_tanf_payperfamNorm != .
replace HealthWelfGrumb = HealthWelfGrumb + afdc_up if  afdc_up != .
replace HealthWelfGrumb = HealthWelfGrumb + medicaid_stateadoption if  medicaid_stateadoption != .
replace HealthWelfGrumb = HealthWelfGrumb + sdce if  sdce != .
replace HealthWelfGrumb = HealthWelfGrumb + snrpresc if  snrpresc != .
replace HealthWelfGrumb = HealthWelfGrumb - timelim if  timelim != .
replace HealthWelfGrumb = HealthWelfGrumb + x_chip_childNorm if  x_chip_childNorm != .
replace HealthWelfGrumb = HealthWelfGrumb + x_chip_infNorm if  x_chip_infNorm != .
replace HealthWelfGrumb = HealthWelfGrumb + x_chip_pregNorm if  x_chip_pregNorm != .
replace HealthWelfGrumb = HealthWelfGrumb + x_chip_pregprebbaNorm if  x_chip_pregprebbaNorm != .
replace HealthWelfGrumb = HealthWelfGrumb + z_ssi_afdcfamNorm if  z_ssi_afdcfamNorm != .
replace HealthWelfGrumb = HealthWelfGrumb + z_tanf_initeligNorm if  z_tanf_initeligNorm != .
replace HealthWelfGrumb = HealthWelfGrumb + z_tanf_payperfamNorm if  z_tanf_payperfamNorm != .
//Housing, Transp., Misc.
replace LibGrumb = LibGrumb + regulation_boehmke_cogrowman if  regulation_boehmke_cogrowman != .
replace ConsGrumb = ConsGrumb + regulation_pain_suffering_limits if  regulation_pain_suffering_limits != .
replace ConsGrumb = ConsGrumb + regulation_rent_control if  regulation_rent_control != .
replace LibGrumb = LibGrumb + regulations_lemonlaw if  regulations_lemonlaw != .
replace HousTransMiscGrumb = HousTransMiscGrumb + regulation_boehmke_cogrowman if  regulation_boehmke_cogrowman != .
replace HousTransMiscGrumb = HousTransMiscGrumb - regulation_pain_suffering_limits if  regulation_pain_suffering_limits != .
replace HousTransMiscGrumb = HousTransMiscGrumb - regulation_rent_control if  regulation_rent_control != .
replace HousTransMiscGrumb = HousTransMiscGrumb + regulations_lemonlaw if  regulations_lemonlaw != .
//Immigration
replace ConsGrumb = ConsGrumb + immigration_english_language if  immigration_english_language != .
replace ConsGrumb = ConsGrumb + immigration_instate_tuition_ille if  immigration_instate_tuition_ille != .
replace ImmigGrumb = ImmigGrumb - immigration_english_language if  immigration_english_language != .
replace ImmigGrumb = ImmigGrumb - immigration_instate_tuition_ille if  immigration_instate_tuition_ille != .
//Labor
replace LibGrumb = LibGrumb + labor_prevailing_wage_laws if  labor_prevailing_wage_laws != .
replace LibGrumb = LibGrumb + labor_state_disability_insurance if  labor_state_disability_insurance != .
sum statemin
gen stateminNorm=(statemin-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + stateminNorm if  stateminNorm != .
sum z_labor_unemployment_compensatio
gen z_labunempcompNorm=(z_labor_unemployment_compensatio-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + z_labunempcompNorm if  z_labunempcompNorm != .
replace LaborGrumb = LaborGrumb + labor_prevailing_wage_laws if  labor_prevailing_wage_laws != .
replace LaborGrumb = LaborGrumb + labor_state_disability_insurance if  labor_state_disability_insurance != .
replace LaborGrumb = LaborGrumb + stateminNorm if  stateminNorm != .
replace LaborGrumb = LaborGrumb + z_labunempcompNorm if  z_labunempcompNorm != .
//LGBT rights
replace ConsGrumb = ConsGrumb + gaymarban if  gaymarban != .
replace ConsGrumb = ConsGrumb + gayrights_ban_sodomy if  gayrights_ban_sodomy != .
replace LibGrumb = LibGrumb + gayrights_hatecrimes if  gayrights_hatecrimes != .
gen w_gay_civmarNorm= w_gayrights_civilunions_marriage
replace w_gay_civmarNorm=1 if w_gay_civmarNorm==2
replace ConsGrumb = ConsGrumb + w_gay_civmarNorm if  w_gay_civmarNorm != .
gen w_gay_empdiscNorm= w_gayrights_employment_discrimit
replace w_gay_empdiscNorm=1 if w_gay_empdiscNorm==2
replace LibGrumb = LibGrumb + w_gay_empdiscNorm if  w_gay_empdiscNorm != .
gen w_gay_pubaccomNorm= w_gayrights_public_accomodations
replace w_gay_pubaccomNorm=1 if w_gay_pubaccomNorm==2
replace LibGrumb = LibGrumb + w_gay_pubaccomNorm if  w_gay_pubaccomNorm != .
replace LGBTGrumb = LGBTGrumb - gaymarban if  gaymarban != .
replace LGBTGrumb = LGBTGrumb - gayrights_ban_sodomy if  gayrights_ban_sodomy != .
replace LGBTGrumb = LGBTGrumb + gayrights_hatecrimes if  gayrights_hatecrimes != .
replace LGBTGrumb = LGBTGrumb - w_gay_civmarNorm if  w_gay_civmarNorm != .
replace LGBTGrumb = LGBTGrumb + w_gay_empdiscNorm if  w_gay_empdiscNorm != .
replace LGBTGrumb = LGBTGrumb + w_gay_pubaccomNorm if  w_gay_pubaccomNorm != .
//Marijuana
replace LibGrumb = LibGrumb + drugs_marijua_decrimilization if  drugs_marijua_decrimilization != .
replace LibGrumb = LibGrumb + drugs_medical_marijua if  drugs_medical_marijua != .
replace MarijGrumb = MarijGrumb + drugs_marijua_decrimilization if  drugs_marijua_decrimilization != .
replace MarijGrumb = MarijGrumb + drugs_medical_marijua if  drugs_medical_marijua != .
//Taxes
sum x_sales_taxes
gen x_salestaxNorm=(x_sales_taxes-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + x_salestaxNorm if  x_salestaxNorm != .
replace LibGrumb = LibGrumb + earned_income_taxcredit if  earned_income_taxcredit != .
replace LibGrumb = LibGrumb + estate_tax if  estate_tax != .
replace LibGrumb = LibGrumb + income_taxes if  income_taxes != .
sum x_top_corporateincometaxrate
gen x_corptaxNorm=(x_top_corporateincometaxrate-r(min))/(r(max)-r(min))
replace LibGrumb = LibGrumb + x_corptaxNorm if  x_corptaxNorm != .
replace TaxGrumb = TaxGrumb + x_salestaxNorm if  x_salestaxNorm != .
replace TaxGrumb = TaxGrumb + earned_income_taxcredit if  earned_income_taxcredit != .
replace TaxGrumb = TaxGrumb + estate_tax if  estate_tax != .
replace TaxGrumb = TaxGrumb + income_taxes if  income_taxes != .
replace TaxGrumb = TaxGrumb + x_corptaxNorm if  x_corptaxNorm != .
//Voting
replace LibGrumb = LibGrumb + absvot if  absvot != .
replace LibGrumb = LibGrumb + earlvot if  earlvot != .
replace LibGrumb = LibGrumb + motorvoter if  motorvoter != .
replace VotingGrumb = VotingGrumb + absvot if  absvot != .
replace VotingGrumb = VotingGrumb + earlvot if  earlvot != .
replace VotingGrumb = VotingGrumb + motorvoter if  motorvoter != .
//Net Liberal Grumb
gen NetLibGrumb=LibGrumb-ConsGrumb

///////////////////////////////////////////