///////////////////////////
// Post estimation: Panel models
///////////////////////////
cd "../../OUTPUT/Regression"

/////////////////////
//Cons Policies
/////////////////////
cd "ConsPol"

//Fixed effects plot
coefplot m_conspolicy_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolicy_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolicy_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolicy_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolicy_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolicy_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(2.4(.2)3.4) ysc(range(2.4 3.4)) yline(2.4(.05)3.4, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolicy_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(2.4(.2)3.4) ysc(range(2.4 3.4)) yline(2.4(.05)3.4, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolicy_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(2.4(.2)3.4) ysc(range(2.4 3.4)) yline(2.4(.05)3.4, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (conventional)
/////////////////////
cd "../ConsPolConv"

//Fixed effects plot
coefplot m_conspolicyCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolicyCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolicyCONV_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolicyCONV_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolicyCONV_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolicyCONV_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(3(.2)4.8) ysc(range(3 4.8)) yline(3(.05) 4.8, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolicyCONV_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(3(.2)4.8) ysc(range(3 4.8)) yline(3(.05) 4.8, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolicyCONV_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(3(.2)4.8) ysc(range(3 4.8)) yline(3(.05) 4.8, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Grumbach)
/////////////////////
cd "../ConsPolGrumb"

//Fixed effects plot
coefplot m_conspolGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolGrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolGrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolGrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolGrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(5(.5)6.5) ysc(range(5 6.5)) yline(5(.05)6.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolGrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(5(.5)6.5) ysc(range(5 6.5)) yline(5(.05)6.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolGrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(5(.5)6.5) ysc(range(5 6.5)) yline(5(.05)6.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Grsman)
/////////////////////
cd "../ConsPolGrsman"

//Fixed effects plot
coefplot m_conspolGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolGrsman_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolGrsman_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolGrsman_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolGrsman_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(3(.5)4.5) ysc(range(3 4.5)) yline(3(.05)4.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolGrsman_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(3(.5)4.5) ysc(range(3 4.5)) yline(3(.05)4.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolGrsman_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(3(.5)4.5) ysc(range(3 4.5)) yline(3(.05)4.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Conv, 2018)
/////////////////////
cd "../ConsPolNikConv"

//Fixed effects plot
coefplot m_consnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_consnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_consnikconv_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_consnikconv_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_consnikconv_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_consnikconv_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(2(1)5) ysc(range(2 5)) yline(2(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_consnikconv_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(2(1)5) ysc(range(2 5)) yline(2(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_consnikconv_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(2(1)5) ysc(range(2 5)) yline(2(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Size/Scope, 2018)
/////////////////////
cd "../ConsPolnikSizeScope"

//Fixed effects plot
coefplot m_consniksizescope_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_consniksizescope_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_consniksizescope_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_consniksizescope_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_consniksizescope_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_consniksizescope_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(1(.5)3) ysc(range(1 3)) yline(1(.25)3, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_consniksizescope_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(1(.5)3) ysc(range(1 3)) yline(1(.25)3, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_consniksizescope_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(1(.5)3) ysc(range(1 3)) yline(1(.25)3, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Boehmke ME, 2018)
/////////////////////
cd "../ConsPolNikBoehmME"

//Fixed effects plot
coefplot m_conspolnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolnikboehmME_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolnikboehmME_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolnikboehmME_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolnikboehmME_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(.5)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolnikboehmME_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(.5)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolnikboehmME_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(.5)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Boehmke FD, 2018)
/////////////////////
cd "../ConsPolNikBoehmFD"

//Fixed effects plot
coefplot m_conspolnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolnikboehmFD_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolnikboehmFD_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolnikboehmFD_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolnikboehmFD_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(1)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolnikboehmFD_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(1)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolnikboehmFD_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(1)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Grumbach, 2018)
/////////////////////
cd "../ConsPolNikGrumb"

//Fixed effects plot
coefplot m_conspolnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolnikgrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolnikgrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolnikgrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolnikgrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(3(.5)5) ysc(range(3 5)) yline(3(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolnikgrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(3(.5)5) ysc(range(3 5)) yline(3(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolnikgrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(3(.5)5) ysc(range(3 5)) yline(3(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (2019 coding, size/scope)
/////////////////////
cd "../ConsPol2019size"

//Fixed effects plot
coefplot m_conspol2019size_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspol2019size_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspol2019size_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspol2019size_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspol2019size_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspol2019size_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(8(1)12) ysc(range(8 12)) yline(8(.25)12, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspol2019size_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(8(1)12) ysc(range(8 12)) yline(8(.25)12, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspol2019size_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(8(1)12) ysc(range(8 12)) yline(8(.25)12, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (2019 coding, conventional)
/////////////////////
cd "../ConsPol2019conv"

//Fixed effects plot
coefplot m_conspol2019conv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspol2019conv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspol2019conv_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspol2019conv_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspol2019conv_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspol2019conv_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(10(1)15) ysc(range(10 15)) yline(10(.25)15, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspol2019conv_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(10(1)15) ysc(range(10 15)) yline(10(.25)15, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspol2019conv_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(10(1)15) ysc(range(10 15)) yline(10(.25)15, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

///////////////////////////////////////////
