///////////////////////////
// Post estimation: Panel models
///////////////////////////
cd "../../OUTPUT/Regression"

/////////////////////
//Lib Policies
/////////////////////
cd "LibPol"

//Fixed effects plot
coefplot m_libpolicy_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolicy_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolicy_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolicy_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolicy_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolicy_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(19(.2)20.2) ysc(range(19 20.2)) yline(19(.05)20.2, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolicy_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(19(.2)20.2) ysc(range(19 20.2)) yline(19(.05)20.2, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolicy_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(19(.2)20.2) ysc(range(19 20.2)) yline(19(.05)20.2, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (conventional)
/////////////////////
cd "../LibPolConv"

//Fixed effects plot
coefplot m_libpolicyCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolicyCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolicyCONV_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolicyCONV_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolicyCONV_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolicyCONV_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(17(1)21) ysc(range(17 21)) yline(17(.5)21, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolicyCONV_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(17(1)21) ysc(range(17 21)) yline(17(.5)21, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolicyCONV_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(17(1)21) ysc(range(17 21)) yline(17(.5)21, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Grumbach)
/////////////////////
cd "../LibPolGrumb"

//Fixed effects plot
coefplot m_libpolGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolGrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolGrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolGrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolGrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(19(.5)23) ysc(range(19 23)) yline(19(.25)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolGrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(19(.5)23) ysc(range(19 23)) yline(19(.25)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolGrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(19(.5)23) ysc(range(19 23)) yline(19(.25)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Grsman)
/////////////////////
cd "../LibPolGrsman"

//Fixed effects plot
coefplot m_libpolGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolGrsman_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolGrsman_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolGrsman_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolGrsman_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(14(.5)18) ysc(range(14 18)) yline(14(.25)18, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolGrsman_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(14(.5)18) ysc(range(14 18)) yline(14(.25)18, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolGrsman_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(14(.5)18) ysc(range(14 18)) yline(14(.25)18, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Conv, 2018)
/////////////////////
cd "../LibPolnikConv"

//Fixed effects plot
coefplot m_libnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libnikconv_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libnikconv_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libnikconv_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libnikconv_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(15(1)25) ysc(range(15 25)) yline(15(.5)25, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libnikconv_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(15(1)25) ysc(range(15 25)) yline(15(.5)25, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libnikconv_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(15(1)25) ysc(range(15 25)) yline(15(.5)25, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Size/Scope, 2018)
/////////////////////
cd "../LibPolnikSizeScope"

//Fixed effects plot
coefplot m_libniksizescope_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libniksizescope_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libniksizescope_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libniksizescope_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libniksizescope_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libniksizescope_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(17(1)23) ysc(range(17 23)) yline(17(.5)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libniksizescope_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(17(1)23) ysc(range(17 23)) yline(17(.5)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libniksizescope_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(17(1)23) ysc(range(17 23)) yline(17(.5)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Boehmke ME, 2018)
/////////////////////
cd "../LibPolNikBoehmME"

//Fixed effects plot
coefplot m_libpolnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolnikboehmME_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolnikboehmME_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolnikboehmME_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolnikboehmME_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(12(1)17) ysc(range(12 17)) yline(12(.5)17, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolnikboehmME_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(12(1)17) ysc(range(12 17)) yline(12(.5)17, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolnikboehmME_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(12(1)17) ysc(range(12 17)) yline(12(.5)17, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Boehmke FD, 2018)
/////////////////////
cd "../LibPolNikBoehmFD"

//Fixed effects plot
coefplot m_libpolnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolnikboehmFD_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolnikboehmFD_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolnikboehmFD_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolnikboehmFD_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(25(1)35) ysc(range(25 35)) yline(25(.5)35, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolnikboehmFD_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(25(1)35) ysc(range(25 35)) yline(25(.5)35, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolnikboehmFD_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(25(1)35) ysc(range(25 35)) yline(25(.5)35, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Grumbach, 2018)
/////////////////////
cd "../LibPolNikGrumb"

//Fixed effects plot
coefplot m_libpolnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolnikgrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolnikgrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolnikgrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolnikgrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolnikgrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolnikgrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (2019 coding, size/scope)
/////////////////////
cd "../LibPol2019size"

//Fixed effects plot
coefplot m_libpol2019size_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpol2019size_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpol2019size_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpol2019size_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpol2019size_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpol2019size_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(80(5)100) ysc(range(80 100)) yline(80(2.5)100, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpol2019size_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(80(5)100) ysc(range(80 100)) yline(80(2.5)100, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpol2019size_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(80(5)100) ysc(range(80 100)) yline(80(2.5)100, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (2019 coding, conventional)
/////////////////////
cd "../LibPol2019conv"

//Fixed effects plot
coefplot m_libpol2019conv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpol2019conv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpol2019conv_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpol2019conv_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpol2019conv_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpol2019conv_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(50(5)75) ysc(range(50 75)) yline(50(2.5)75, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpol2019conv_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(50(5)75) ysc(range(50 75)) yline(50(2.5)75, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpol2019conv_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(50(5)75) ysc(range(50 75)) yline(50(2.5)75, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

///////////////////////////////////////////
