///////////////////////////
// Post estimation: Panel models
///////////////////////////
cd "../../OUTPUT/Regression/"

/////////////////////
//Net Lib Policies
/////////////////////
cd "NetLibPol"

//Fixed effects plot
coefplot m_netlibpol_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibpol_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibpol_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibpol_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibpol_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibpol_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(16(.2)17.2) ysc(range(16 17.2)) yline(16(.05)17.2, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibpol_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(16(.2)17.2) ysc(range(16 17.2)) yline(16(.05)17.2, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibpol_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(16(.2)17.2) ysc(range(16 17.2)) yline(16(.05)17.2, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (conventional)
/////////////////////
cd "../NetLibPolConv"

//Fixed effects plot
coefplot m_netlibpolCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibpolCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibpolCONV_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibpolCONV_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibpolCONV_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibpolCONV_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(12(1)18) ysc(range(12 18)) yline(12(.25)18, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibpolCONV_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(12(1)18) ysc(range(12 18)) yline(12(.25)18, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibpolCONV_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(12(1)18) ysc(range(12 18)) yline(12(.25)18, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Grumbach)
/////////////////////
cd "../NetLibPolGrumb"

//Fixed effects plot
coefplot m_netlibGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibGrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibGrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibGrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibGrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(13(1)17) ysc(range(13 17)) yline(13(.25)17, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibGrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(13(1)17) ysc(range(13 17)) yline(13(.25)17, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibGrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(13(1)17) ysc(range(13 17)) yline(13(.25)17, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Grsman)
/////////////////////
cd "../NetLibPolGrsman"

//Fixed effects plot
coefplot m_netlibGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibGrsman_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibGrsman_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibGrsman_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibGrsman_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(10(1)15) ysc(range(10 15)) yline(10(.25)15, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibGrsman_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(10(1)15) ysc(range(10 15)) yline(10(.25)15, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibGrsman_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(10(1)15) ysc(range(10 15)) yline(10(.25)15, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Conv, 2018)
/////////////////////
cd "../NetLibnikConv"

//Fixed effects plot
coefplot m_netlibnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibnikconv_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibnikconv_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibnikconv_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibnikconv_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(13(1)20) ysc(range(13 20)) yline(13(.25)20, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibnikconv_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(13(1)20) ysc(range(13 20)) yline(13(.25)20, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibnikconv_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(13(1)20) ysc(range(13 20)) yline(13(.25)20, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Size/Scope, 2018)
/////////////////////
cd "../NetLibnikSizeScope"

//Fixed effects plot
coefplot m_netlibniksizescope_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibniksizescope_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibniksizescope_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibniksizescope_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibniksizescope_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibniksizescope_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(15(1)19) ysc(range(15 19)) yline(15(.25)19, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibniksizescope_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(15(1)19) ysc(range(15 19)) yline(15(.25)19, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibniksizescope_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(15(1)19) ysc(range(15 19)) yline(15(.25)19, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Boehmke ME, 2018)
/////////////////////
cd "../NetLibPolNikBoehmME"

//Fixed effects plot
coefplot m_netlibnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibnikboehmME_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibnikboehmME_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibnikboehmME_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibnikboehmME_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(-10(1)0) ysc(range(-10 0)) yline(-10(.5)0, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibnikboehmME_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(-10(1)0) ysc(range(-10 0)) yline(-10(.5)0, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibnikboehmME_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-10(1)0) ysc(range(-10 0)) yline(-10(.5)0, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Boehmke FD, 2018)
/////////////////////
cd "../NetLibPolNikBoehmFD"

//Fixed effects plot
coefplot m_netlibnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibnikboehmFD_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibnikboehmFD_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibnikboehmFD_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibnikboehmFD_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(0(1)10) ysc(range(0 10)) yline(0(.5)10, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibnikboehmFD_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(0(1)10) ysc(range(0 10)) yline(0(.5)10, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibnikboehmFD_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(0(1)10) ysc(range(0 10)) yline(0(.5)10, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Grumbach, 2018)
/////////////////////
cd "../NetLibPolNikGrumb"

//Fixed effects plot
coefplot m_netlibnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibnikgrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibnikgrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibnikgrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibnikgrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibnikgrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibnikgrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (2019 coding, Grossman, size/scope)
/////////////////////
cd "../NetLib2019size"

//Fixed effects plot
coefplot m_netlib2019size_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlib2019size_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlib2019size_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlib2019size_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlib2019size_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlib2019size_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(78(1)85) ysc(range(78 85)) yline(78(.5)85, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlib2019size_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(78(1)85) ysc(range(78 85)) yline(78(.5)85, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlib2019size_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(78(1)85) ysc(range(78 85)) yline(78(.5)85, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (2019 coding, Grossman, conventional)
/////////////////////
cd "../NetLib2019conv"

//Fixed effects plot
coefplot m_netlib2019conv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlib2019conv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlib2019conv_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlib2019conv_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlib2019conv_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlib2019conv_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(50(1)60) ysc(range(50 60)) yline(50(.5)60, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlib2019conv_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(50(1)60) ysc(range(50 60)) yline(50(.5)60, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlib2019conv_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(50(1)60) ysc(range(50 60)) yline(50(.5)60, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

///////////////////////////////////////////
