///////////////////////////
// Post estimation: Panel models
///////////////////////////
cd "../../OUTPUT/Regression/"

/////////////////////
//Expenditures
/////////////////////
cd "Expend"

//Fixed effects plot
coefplot m_expend_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Expenditures",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_expend.png",replace
coefplot m_expend_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Expenditures",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_expend.png",replace
coefplot m_expend_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Expenditures",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_expend.png",replace
coefplot m_expend_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Expenditures",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_expend.png",replace
coefplot m_expend_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Expenditures",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_expend.png",replace

//Bare model
est restore m_expend_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(11.8(.2)13.6) ysc(range(11.8 13.6)) yline(11.8(.05)13.6, lpat(dot)) ytitle("Expenditures (% GSP)") title("Expenditures (%GSP), with only South as control")
graph export "Bare_expend.png",replace

//Full model
est restore m_expend_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(11.8(.2)13.6) ysc(range(11.8 13.6)) yline(11.8(.05)13.6, lpat(dot)) ytitle("Expenditures (% GSP)") title("Expenditures (%GSP)")
graph export "Full_expend.png",replace

//No yr FE model
est restore m_expend_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(11.8(.2)13.6) ysc(range(11.8 13.6)) yline(11.8(.05)13.6, lpat(dot)) ytitle("Expenditures (% GSP)") title("Expenditures (%GSP), no yr FE")
graph export "NoYrFE_expend.png",replace

/////////////////////
//Policy Liberalism
/////////////////////
cd "../PolLib"

//Fixed effects plot
coefplot m_pollib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_pollib.png",replace
coefplot m_pollib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy lib",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_pollib.png",replace
coefplot m_pollib_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy lib",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_pollib.png",replace
coefplot m_pollib_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy lib",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_pollib.png",replace
coefplot m_pollib_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_pollib.png",replace

//Bare model
est restore m_pollib_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(-0.2(.2)0.2) ysc(range(-0.2 0.2)) yline(-0.2(.05) 0.2, lpat(dot)) ytitle("Policy Liberalism") title("Policy Liberalism, with only South as control")
graph export "Bare_pollib.png",replace

//Full model
est restore m_pollib_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(-0.2(.2)0.2) ysc(range(-0.2 0.2)) yline(-0.2(.05) 0.2, lpat(dot)) ytitle("Policy Liberalism") title("Policy Liberalism")
graph export "Full_pollib.png",replace

//No yr FE model
est restore m_pollib_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.2(.2)0.2) ysc(range(-0.2 0.2)) yline(-0.2(.05) 0.2, lpat(dot)) ytitle("Policy Liberalism") title("Policy Liberalism, no yr FE")
graph export "NoYrFE_pollib.png",replace

/////////////////////
//Social Policy Liberalism
/////////////////////
cd "../PolLibSoc"

//Fixed effects plot
coefplot m_soclib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Soc Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_soclib.png",replace
coefplot m_soclib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Soc Policy lib",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_soclib.png",replace
coefplot m_soclib_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Soc Policy lib",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_soclib.png",replace
coefplot m_soclib_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Soc Policy lib",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_soclib.png",replace
coefplot m_soclib_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Soc Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_soclib.png",replace

//Bare model
est restore m_soclib_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Soc Policy Liberalism") title("Soc Policy Liberalism, with only South as control")
graph export "Bare_soclib.png",replace

//Full model
est restore m_soclib_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Soc Policy Liberalism") title("Soc Policy Liberalism")
graph export "Full_soclib.png",replace

//No yr FE model
est restore m_soclib_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Soc Policy Liberalism") title("Soc Policy Liberalism, no yr FE")
graph export "NoYrFE_soclib.png",replace

/////////////////////
//Econ Policy Liberalism
/////////////////////
cd "../PolLibEcon"

//Fixed effects plot
coefplot m_econlib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Econ Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_econlib.png",replace
coefplot m_econlib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Econ Policy lib",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_econlib.png",replace
coefplot m_econlib_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Econ Policy lib",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_econlib.png",replace
coefplot m_econlib_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Econ Policy lib",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_econlib.png",replace
coefplot m_econlib_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Econ Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_econlib.png",replace

//Bare model
est restore m_econlib_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Econ Policy Liberalism") title("Econ Policy Liberalism, with only South as control")
graph export "Bare_econlib.png",replace

//Full model
est restore m_econlib_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Econ Policy Liberalism") title("Econ Policy Liberalism")
graph export "Full_econlib.png",replace

//No yr FE model
est restore m_econlib_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Econ Policy Liberalism") title("Econ Policy Liberalism, no yr FE")
graph export "NoYrFE_econlib.png",replace

/////////////////////
//Innovation (logged)
/////////////////////
cd "../InnovLog"

//Fixed effects plot
coefplot m_innov_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness (logged)",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_innov.png",replace
coefplot m_innov_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness (logged)",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_innov.png",replace
coefplot m_innov_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness (logged)",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_innov.png",replace
coefplot m_innov_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness (logged)",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_innov.png",replace
coefplot m_innov_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness (logged)",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_innov.png",replace

//Bare model
est restore m_innov_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(-3(.2)-2.4) ysc(range(-3 -2.4)) yline(-3(.05) -2.4, lpat(dot)) ytitle("log(Policy Innovativeness)") title("Policy Innovativeness (logged), with only South as control")
graph export "Bare_innov.png",replace

//Full model
est restore m_innov_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(-3(.2)-2.4) ysc(range(-3 -2.4)) yline(-3(.05) -2.4, lpat(dot)) ytitle("log(Policy Innovativeness)") title("Policy Innovativeness (logged)")
graph export "Full_innov.png",replace

//No yr FE model
est restore m_innov_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3(.2)-2.4) ysc(range(-3 -2.4)) yline(-3(.05) -2.4, lpat(dot)) ytitle("log(Policy Innovativeness)") title("Policy Innovativeness (logged), no yr FE")
graph export "NoYrFE_innov.png",replace

/////////////////////
//Innovation (raw)
/////////////////////
cd "../Innov"

//Fixed effects plot
coefplot m_innovraw_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_innov.png",replace
coefplot m_innovraw_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_innov.png",replace
coefplot m_innovraw_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_innov.png",replace
coefplot m_innovraw_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_innov.png",replace
coefplot m_innovraw_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_innov.png",replace

//Bare model
est restore m_innovraw_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(0(.02)0.14) ysc(range(0 0.14)) yline(0(.005)0.14, lpat(dot)) ytitle("Policy Innovativeness") title("Policy Innovativeness, with only South as control")
graph export "Bare_innov.png",replace

//Full model
est restore m_innovraw_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(0(.02)0.14) ysc(range(0 0.14)) yline(0(.005)0.14, lpat(dot)) ytitle("Policy Innovativeness") title("Policy Innovativeness")
graph export "Full_innov.png",replace

//No yr FE model
est restore m_innovraw_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(0(.02)0.14) ysc(range(0 0.14)) yline(0(.005)0.14, lpat(dot)) ytitle("Policy Innovativeness") title("Policy Innovativeness, no yr FE")
graph export "NoYrFE_innov.png",replace

///////////////////////////////////////////