///////////////////////////
// Post estimation: Panel models
///////////////////////////
cd "../OUTPUT"

/////////////////////
//Lib Policies
/////////////////////
cd "Regression/LibPol"

//Fixed effects plot
coefplot m_libpolicy_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolicy_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolicy_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolicy_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolicy_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolicy_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(19(.2)20.2) ysc(range(19 20.2)) yline(19(.05)20.2, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolicy_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(19(.2)20.2) ysc(range(19 20.2)) yline(19(.05)20.2, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolicy_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(19(.2)20.2) ysc(range(19 20.2)) yline(19(.05)20.2, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (conventional)
/////////////////////
cd "../LibPolConv"

//Fixed effects plot
coefplot m_libpolicyCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolicyCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolicyCONV_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolicyCONV_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolicyCONV_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolicyCONV_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(17(1)21) ysc(range(17 21)) yline(17(.5)21, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolicyCONV_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(17(1)21) ysc(range(17 21)) yline(17(.5)21, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolicyCONV_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(17(1)21) ysc(range(17 21)) yline(17(.5)21, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Grumbach)
/////////////////////
cd "../LibPolGrumb"

//Fixed effects plot
coefplot m_libpolGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolGrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolGrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolGrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolGrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(19(.5)23) ysc(range(19 23)) yline(19(.25)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolGrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(19(.5)23) ysc(range(19 23)) yline(19(.25)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolGrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(19(.5)23) ysc(range(19 23)) yline(19(.25)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Grsman)
/////////////////////
cd "../LibPolGrsman"

//Fixed effects plot
coefplot m_libpolGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolGrsman_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolGrsman_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolGrsman_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolGrsman_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(14(.5)18) ysc(range(14 18)) yline(14(.25)18, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolGrsman_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(14(.5)18) ysc(range(14 18)) yline(14(.25)18, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolGrsman_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(14(.5)18) ysc(range(14 18)) yline(14(.25)18, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Conv, 2018)
/////////////////////
cd "../LibPolnikConv"

//Fixed effects plot
coefplot m_libnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libnikconv_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libnikconv_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libnikconv_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libnikconv_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(15(1)25) ysc(range(15 25)) yline(15(.5)25, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libnikconv_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(15(1)25) ysc(range(15 25)) yline(15(.5)25, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libnikconv_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(15(1)25) ysc(range(15 25)) yline(15(.5)25, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Size/Scope, 2018)
/////////////////////
cd "../LibPolnikSizeScope"

//Fixed effects plot
coefplot m_libniksizescope_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libniksizescope_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libniksizescope_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libniksizescope_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libniksizescope_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libniksizescope_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(17(1)23) ysc(range(17 23)) yline(17(.5)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libniksizescope_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(17(1)23) ysc(range(17 23)) yline(17(.5)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libniksizescope_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(17(1)23) ysc(range(17 23)) yline(17(.5)23, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Boehmke ME, 2018)
/////////////////////
cd "../LibPolNikBoehmME"

//Fixed effects plot
coefplot m_libpolnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolnikboehmME_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolnikboehmME_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolnikboehmME_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolnikboehmME_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(12(1)17) ysc(range(12 17)) yline(12(.5)17, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolnikboehmME_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(12(1)17) ysc(range(12 17)) yline(12(.5)17, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolnikboehmME_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(12(1)17) ysc(range(12 17)) yline(12(.5)17, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Boehmke FD, 2018)
/////////////////////
cd "../LibPolNikBoehmFD"

//Fixed effects plot
coefplot m_libpolnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolnikboehmFD_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolnikboehmFD_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolnikboehmFD_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolnikboehmFD_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(25(1)35) ysc(range(25 35)) yline(25(.5)35, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolnikboehmFD_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(25(1)35) ysc(range(25 35)) yline(25(.5)35, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolnikboehmFD_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(25(1)35) ysc(range(25 35)) yline(25(.5)35, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Grumbach, 2018)
/////////////////////
cd "../LibPolNikGrumb"

//Fixed effects plot
coefplot m_libpolnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libpolicy.png",replace
coefplot m_libpolnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libpolicy.png",replace
coefplot m_libpolnikgrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_libpolicy.png",replace
coefplot m_libpolnikgrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_libpolicy.png",replace
coefplot m_libpolnikgrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_libpolicy.png",replace

//Bare model
est restore m_libpolnikgrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, with only South as control")
graph export "Bare_libpolicy.png",replace

//Full model
est restore m_libpolnikgrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count")
graph export "Full_libpolicy.png",replace

//No yr FE model
est restore m_libpolnikgrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Count Liberal Policies") title("Lib. Policy count, no year FE")
graph export "NoYrFE_libpolicy.png",replace


/////////////////////
//Cons Policies
/////////////////////
cd "../ConsPol"

//Fixed effects plot
coefplot m_conspolicy_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolicy_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolicy_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolicy_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolicy_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolicy_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(2.4(.2)3.4) ysc(range(2.4 3.4)) yline(2.4(.05)3.4, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolicy_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(2.4(.2)3.4) ysc(range(2.4 3.4)) yline(2.4(.05)3.4, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolicy_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(2.4(.2)3.4) ysc(range(2.4 3.4)) yline(2.4(.05)3.4, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (conventional)
/////////////////////
cd "../ConsPolConv"

//Fixed effects plot
coefplot m_conspolicyCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolicyCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolicyCONV_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolicyCONV_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolicyCONV_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolicyCONV_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(3(.2)4.8) ysc(range(3 4.8)) yline(3(.05) 4.8, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolicyCONV_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(3(.2)4.8) ysc(range(3 4.8)) yline(3(.05) 4.8, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolicyCONV_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(3(.2)4.8) ysc(range(3 4.8)) yline(3(.05) 4.8, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Grumbach)
/////////////////////
cd "../ConsPolGrumb"

//Fixed effects plot
coefplot m_conspolGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolGrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolGrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolGrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolGrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(5(.5)6.5) ysc(range(5 6.5)) yline(5(.05)6.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolGrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(5(.5)6.5) ysc(range(5 6.5)) yline(5(.05)6.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolGrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(5(.5)6.5) ysc(range(5 6.5)) yline(5(.05)6.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Grsman)
/////////////////////
cd "../ConsPolGrsman"

//Fixed effects plot
coefplot m_conspolGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolGrsman_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolGrsman_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolGrsman_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolGrsman_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(3(.5)4.5) ysc(range(3 4.5)) yline(3(.05)4.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolGrsman_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(3(.5)4.5) ysc(range(3 4.5)) yline(3(.05)4.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolGrsman_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(3(.5)4.5) ysc(range(3 4.5)) yline(3(.05)4.5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Conv, 2018)
/////////////////////
cd "../ConsPolNikConv"

//Fixed effects plot
coefplot m_consnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_consnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_consnikconv_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_consnikconv_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_consnikconv_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_consnikconv_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(2(1)5) ysc(range(2 5)) yline(2(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_consnikconv_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(2(1)5) ysc(range(2 5)) yline(2(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_consnikconv_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(2(1)5) ysc(range(2 5)) yline(2(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Size/Scope, 2018)
/////////////////////
cd "../ConsPolnikSizeScope"

//Fixed effects plot
coefplot m_consniksizescope_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_consniksizescope_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_consniksizescope_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_consniksizescope_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_consniksizescope_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_consniksizescope_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(1(.5)3) ysc(range(1 3)) yline(1(.25)3, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_consniksizescope_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(1(.5)3) ysc(range(1 3)) yline(1(.25)3, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_consniksizescope_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(1(.5)3) ysc(range(1 3)) yline(1(.25)3, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Boehmke ME, 2018)
/////////////////////
cd "../ConsPolNikBoehmME"

//Fixed effects plot
coefplot m_conspolnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolnikboehmME_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolnikboehmME_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolnikboehmME_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolnikboehmME_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(.5)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolnikboehmME_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(.5)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolnikboehmME_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(.5)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Boehmke FD, 2018)
/////////////////////
cd "../ConsPolNikBoehmFD"

//Fixed effects plot
coefplot m_conspolnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolnikboehmFD_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolnikboehmFD_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolnikboehmFD_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolnikboehmFD_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(1)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolnikboehmFD_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(1)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolnikboehmFD_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(20(2)30) ysc(range(20 30)) yline(20(1)30, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Grumbach, 2018)
/////////////////////
cd "../ConsPolNikGrumb"

//Fixed effects plot
coefplot m_conspolnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conspolicy.png",replace
coefplot m_conspolnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conspolicy.png",replace
coefplot m_conspolnikgrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_conspolicy.png",replace
coefplot m_conspolnikgrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_conspolicy.png",replace
coefplot m_conspolnikgrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Cons Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_conspolicy.png",replace

//Bare model
est restore m_conspolnikgrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(3(.5)5) ysc(range(3 5)) yline(3(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, with only South as control")
graph export "Bare_conspolicy.png",replace

//Full model
est restore m_conspolnikgrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(3(.5)5) ysc(range(3 5)) yline(3(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count")
graph export "Full_conspolicy.png",replace

//No yr FE model
est restore m_conspolnikgrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(3(.5)5) ysc(range(3 5)) yline(3(.25)5, lpat(dot)) ytitle("Count Cons Policies") title("Cons. Policy count, no year FE")
graph export "NoYrFE_conspolicy.png",replace


/////////////////////
//Net Lib Policies
/////////////////////
cd "../NetLibPol"

//Fixed effects plot
coefplot m_netlibpol_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibpol_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibpol_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibpol_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibpol_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibpol_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(16(.2)17.2) ysc(range(16 17.2)) yline(16(.05)17.2, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibpol_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(16(.2)17.2) ysc(range(16 17.2)) yline(16(.05)17.2, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibpol_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(16(.2)17.2) ysc(range(16 17.2)) yline(16(.05)17.2, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (conventional)
/////////////////////
cd "../NetLibPolConv"

//Fixed effects plot
coefplot m_netlibpolCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibpolCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibpolCONV_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibpolCONV_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibpolCONV_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibpolCONV_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(12(1)18) ysc(range(12 18)) yline(12(.25)18, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibpolCONV_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(12(1)18) ysc(range(12 18)) yline(12(.25)18, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibpolCONV_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(12(1)18) ysc(range(12 18)) yline(12(.25)18, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Grumbach)
/////////////////////
cd "../NetLibPolGrumb"

//Fixed effects plot
coefplot m_netlibGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibGrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibGrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibGrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibGrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(13(1)17) ysc(range(13 17)) yline(13(.25)17, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibGrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(13(1)17) ysc(range(13 17)) yline(13(.25)17, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibGrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(13(1)17) ysc(range(13 17)) yline(13(.25)17, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Grsman)
/////////////////////
cd "../NetLibPolGrsman"

//Fixed effects plot
coefplot m_netlibGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibGrsman_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibGrsman_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibGrsman_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibGrsman_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(10(1)15) ysc(range(10 15)) yline(10(.25)15, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibGrsman_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(10(1)15) ysc(range(10 15)) yline(10(.25)15, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibGrsman_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(10(1)15) ysc(range(10 15)) yline(10(.25)15, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Conv, 2018)
/////////////////////
cd "../NetLibnikConv"

//Fixed effects plot
coefplot m_netlibnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibnikconv_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibnikconv_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibnikconv_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibnikconv_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(13(1)20) ysc(range(13 20)) yline(13(.25)20, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibnikconv_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(13(1)20) ysc(range(13 20)) yline(13(.25)20, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibnikconv_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(13(1)20) ysc(range(13 20)) yline(13(.25)20, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Size/Scope, 2018)
/////////////////////
cd "../NetLibnikSizeScope"

//Fixed effects plot
coefplot m_netlibniksizescope_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibniksizescope_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibniksizescope_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibniksizescope_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibniksizescope_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibniksizescope_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(15(1)19) ysc(range(15 19)) yline(15(.25)19, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibniksizescope_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(15(1)19) ysc(range(15 19)) yline(15(.25)19, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibniksizescope_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(15(1)19) ysc(range(15 19)) yline(15(.25)19, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Boehmke ME, 2018)
/////////////////////
cd "../NetLibPolNikBoehmME"

//Fixed effects plot
coefplot m_netlibnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibnikboehmME_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibnikboehmME_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibnikboehmME_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibnikboehmME_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(-10(1)0) ysc(range(-10 0)) yline(-10(.5)0, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibnikboehmME_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(-10(1)0) ysc(range(-10 0)) yline(-10(.5)0, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibnikboehmME_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-10(1)0) ysc(range(-10 0)) yline(-10(.5)0, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Boehmke FD, 2018)
/////////////////////
cd "../NetLibPolNikBoehmFD"

//Fixed effects plot
coefplot m_netlibnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibnikboehmFD_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibnikboehmFD_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibnikboehmFD_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibnikboehmFD_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(0(1)10) ysc(range(0 10)) yline(0(.5)10, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibnikboehmFD_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(0(1)10) ysc(range(0 10)) yline(0(.5)10, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibnikboehmFD_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(0(1)10) ysc(range(0 10)) yline(0(.5)10, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Grumbach, 2018)
/////////////////////
cd "../NetLibPolNikGrumb"

//Fixed effects plot
coefplot m_netlibnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibpol.png",replace
coefplot m_netlibnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibpol.png",replace
coefplot m_netlibnikgrumb_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_netlibpol.png",replace
coefplot m_netlibnikgrumb_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_netlibpol.png",replace
coefplot m_netlibnikgrumb_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_netlibpol.png",replace

//Bare model
est restore m_netlibnikgrumb_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, with only South as control")
graph export "Bare_netlibpol.png",replace

//Full model
est restore m_netlibnikgrumb_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count")
graph export "Full_netlibpol.png",replace

//No yr FE model
est restore m_netlibnikgrumb_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(300(50)500) ysc(range(300 500)) yline(300(25)500, lpat(dot)) ytitle("Net Count Liberal Policies") title("Net Lib. Policy count, no year FE")
graph export "NoYrFE_netlibpol.png",replace


/////////////////////
//Expenditures
/////////////////////
cd "../Expend"

//Fixed effects plot
coefplot m_expend_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Expenditures",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_expend.png",replace
coefplot m_expend_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Expenditures",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_expend.png",replace
coefplot m_expend_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Expenditures",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_expend.png",replace
coefplot m_expend_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Expenditures",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_expend.png",replace
coefplot m_expend_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Expenditures",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_expend.png",replace

//Bare model
est restore m_expend_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(11.8(.2)13.6) ysc(range(11.8 13.6)) yline(11.8(.05)13.6, lpat(dot)) ytitle("Expenditures (% GSP)") title("Expenditures (%GSP), with only South as control")
graph export "Bare_expend.png",replace

//Full model
est restore m_expend_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(11.8(.2)13.6) ysc(range(11.8 13.6)) yline(11.8(.05)13.6, lpat(dot)) ytitle("Expenditures (% GSP)") title("Expenditures (%GSP)")
graph export "Full_expend.png",replace

//No yr FE model
est restore m_expend_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(11.8(.2)13.6) ysc(range(11.8 13.6)) yline(11.8(.05)13.6, lpat(dot)) ytitle("Expenditures (% GSP)") title("Expenditures (%GSP), no yr FE")
graph export "NoYrFE_expend.png",replace

/////////////////////
//Policy Liberalism
/////////////////////
cd "../PolLib"

//Fixed effects plot
coefplot m_pollib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_pollib.png",replace
coefplot m_pollib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy lib",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_pollib.png",replace
coefplot m_pollib_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy lib",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_pollib.png",replace
coefplot m_pollib_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy lib",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_pollib.png",replace
coefplot m_pollib_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_pollib.png",replace

//Bare model
est restore m_pollib_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(-0.2(.2)0.2) ysc(range(-0.2 0.2)) yline(-0.2(.05) 0.2, lpat(dot)) ytitle("Policy Liberalism") title("Policy Liberalism, with only South as control")
graph export "Bare_pollib.png",replace

//Full model
est restore m_pollib_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(-0.2(.2)0.2) ysc(range(-0.2 0.2)) yline(-0.2(.05) 0.2, lpat(dot)) ytitle("Policy Liberalism") title("Policy Liberalism")
graph export "Full_pollib.png",replace

//No yr FE model
est restore m_pollib_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.2(.2)0.2) ysc(range(-0.2 0.2)) yline(-0.2(.05) 0.2, lpat(dot)) ytitle("Policy Liberalism") title("Policy Liberalism, no yr FE")
graph export "NoYrFE_pollib.png",replace

/////////////////////
//Social Policy Liberalism
/////////////////////
cd "../PolLibSoc"

//Fixed effects plot
coefplot m_soclib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Soc Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_soclib.png",replace
coefplot m_soclib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Soc Policy lib",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_soclib.png",replace
coefplot m_soclib_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Soc Policy lib",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_soclib.png",replace
coefplot m_soclib_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Soc Policy lib",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_soclib.png",replace
coefplot m_soclib_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Soc Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_soclib.png",replace

//Bare model
est restore m_soclib_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Soc Policy Liberalism") title("Soc Policy Liberalism, with only South as control")
graph export "Bare_soclib.png",replace

//Full model
est restore m_soclib_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Soc Policy Liberalism") title("Soc Policy Liberalism")
graph export "Full_soclib.png",replace

//No yr FE model
est restore m_soclib_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Soc Policy Liberalism") title("Soc Policy Liberalism, no yr FE")
graph export "NoYrFE_soclib.png",replace

/////////////////////
//Econ Policy Liberalism
/////////////////////
cd "../PolLibEcon"

//Fixed effects plot
coefplot m_econlib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Econ Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_econlib.png",replace
coefplot m_econlib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Econ Policy lib",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_econlib.png",replace
coefplot m_econlib_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Econ Policy lib",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_econlib.png",replace
coefplot m_econlib_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Econ Policy lib",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_econlib.png",replace
coefplot m_econlib_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Econ Policy lib",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_econlib.png",replace

//Bare model
est restore m_econlib_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Econ Policy Liberalism") title("Econ Policy Liberalism, with only South as control")
graph export "Bare_econlib.png",replace

//Full model
est restore m_econlib_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Econ Policy Liberalism") title("Econ Policy Liberalism")
graph export "Full_econlib.png",replace

//No yr FE model
est restore m_econlib_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.3(.2)0.3) ysc(range(-0.3 0.3)) yline(-0.3(.05) 0.3, lpat(dot)) ytitle("Econ Policy Liberalism") title("Econ Policy Liberalism, no yr FE")
graph export "NoYrFE_econlib.png",replace

/////////////////////
//Innovation (logged)
/////////////////////
cd "../InnovLog"

//Fixed effects plot
coefplot m_innov_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness (logged)",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_innov.png",replace
coefplot m_innov_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness (logged)",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_innov.png",replace
coefplot m_innov_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness (logged)",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_innov.png",replace
coefplot m_innov_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness (logged)",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_innov.png",replace
coefplot m_innov_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness (logged)",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_innov.png",replace

//Bare model
est restore m_innov_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(-3(.2)-2.4) ysc(range(-3 -2.4)) yline(-3(.05) -2.4, lpat(dot)) ytitle("log(Policy Innovativeness)") title("Policy Innovativeness (logged), with only South as control")
graph export "Bare_innov.png",replace

//Full model
est restore m_innov_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(-3(.2)-2.4) ysc(range(-3 -2.4)) yline(-3(.05) -2.4, lpat(dot)) ytitle("log(Policy Innovativeness)") title("Policy Innovativeness (logged)")
graph export "Full_innov.png",replace

//No yr FE model
est restore m_innov_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3(.2)-2.4) ysc(range(-3 -2.4)) yline(-3(.05) -2.4, lpat(dot)) ytitle("log(Policy Innovativeness)") title("Policy Innovativeness (logged), no yr FE")
graph export "NoYrFE_innov.png",replace

/////////////////////
//Innovation (raw)
/////////////////////
cd "../Innov"

//Fixed effects plot
coefplot m_innovraw_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_innov.png",replace
coefplot m_innovraw_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_innov.png",replace
coefplot m_innovraw_bare,keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness",size(small)) sort title("Year-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_yrFE_innov.png",replace
coefplot m_innovraw_ctls, keep(*.year) ylab(,labsize(small)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness",size(small)) sort title("Year-fixed effects",size(small))
graph export "Full_yrFE_innov.png",replace
coefplot m_innovraw_noyrfe, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy Innovativeness",size(small)) sort title("State-fixed effects",size(small)) subtitle("no yr FE",size(vsmall))
graph export "NoYrFE_FE_innov.png",replace

//Bare model
est restore m_innovraw_bare
margins Lrep_chambers,at((asobserved) south year stated)
marginsplot, ylabel(0(.02)0.14) ysc(range(0 0.14)) yline(0(.005)0.14, lpat(dot)) ytitle("Policy Innovativeness") title("Policy Innovativeness, with only South as control")
graph export "Bare_innov.png",replace

//Full model
est restore m_innovraw_ctls
margins Lrep_chambers,at((mean) _all (asobserved) region year stated)
marginsplot, ylabel(0(.02)0.14) ysc(range(0 0.14)) yline(0(.005)0.14, lpat(dot)) ytitle("Policy Innovativeness") title("Policy Innovativeness")
graph export "Full_innov.png",replace

//No yr FE model
est restore m_innovraw_noyrfe
margins Lrep_chambers,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(0(.02)0.14) ysc(range(0 0.14)) yline(0(.005)0.14, lpat(dot)) ytitle("Policy Innovativeness") title("Policy Innovativeness, no yr FE")
graph export "NoYrFE_innov.png",replace
