///////////////////////////
// Post estimation: Change models
///////////////////////////
cd "../../OUTPUT/Change/"

/////////////////////
//Cons Policies Change
/////////////////////
cd "ConsPol"

//Fixed effects plot
coefplot CHm_conspolicy_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_conspolicy_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_conspolicy_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-0.5(.25)0.5) ysc(range(-0.5 0.5)) yline(-0.5(.125)0.5, lpat(dot)) ytitle("Change in Count Cons. Policies") title("Change in Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_conspolicy_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.5(.25)0.5) ysc(range(-0.5 0.5)) yline(-0.5(.125)0.5, lpat(dot)) ytitle("Change in Count Cons. Policies") title("Change in Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_conspolicy_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.5(.25)0.5) ysc(range(-0.5 0.5)) yline(-0.5(.125)0.5, lpat(dot)) ytitle("Change in Count Cons. Policies") title("Change in Cons. Policy count, no state FE")
graph export "NoStFE_conschange.png",replace

//No NJ/PA (outlier) model
est restore CHm_conspolicy_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.5(.25)0.5) ysc(range(-0.5 0.5)) yline(-0.5(.125)0.5, lpat(dot)) ytitle("Change in Count Cons. Policies") title("Change in Cons. Policy count, sans outliers")
graph export "NoOutliers_conschange.png",replace

/////////////////////
//Cons Policies (conventional) Change
/////////////////////
cd "../ConsPolConv"

//Fixed effects plot
coefplot CHm_conspolicyCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_conspolicyCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_conspolicyCONV_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-1(.25)1) ysc(range(-1 1)) yline(-1(.125)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_conspolicyCONV_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(.25)1) ysc(range(-1 1)) yline(-1(.125)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_conspolicyCONV_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.25)1) ysc(range(-1 1)) yline(-1(.125)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_conspolCONV_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.25)1) ysc(range(-1 1)) yline(-1(.125)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Grumbach) Change
/////////////////////
cd "../ConsPolGrumb"

//Fixed effects plot
coefplot CHm_conspolGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_conspolGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_conspolGrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_conspolGrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_conspolGrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_conspolGrumb_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Grsman) Change
/////////////////////
cd "../ConsPolGrsman"

//Fixed effects plot
coefplot CHm_conspolGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_conspolGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_conspolGrsman_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_conspolGrsman_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_conspolGrsman_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_conspolGrsman_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Conv, 2018) Change
/////////////////////
cd "../ConsPolnikConv"

//Fixed effects plot
coefplot CHm_consnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_consnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_consnikconv_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_consnikconv_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_consnikconv_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_consnikconv_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Size/Scope, 2018) Change
/////////////////////
cd "../ConsPolnikSizeScope"

//Fixed effects plot
coefplot CHm_consniksizescope_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_consniksizescope_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_consniksizescope_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-1(.5)1) ysc(range(-1 1)) yline(-1(.25)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_consniksizescope_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(.5)1) ysc(range(-1 1)) yline(-1(.25)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_consniksizescope_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)1) ysc(range(-1 1)) yline(-1(.25)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_consniksizescope_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)1) ysc(range(-1 1)) yline(-1(.25)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Boehmke ME, 2018) Change
/////////////////////
cd "../ConsPolnikboehmME"

//Fixed effects plot
coefplot CHm_consnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_consnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_consnikboehmME_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_consnikboehmME_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_consnikboehmME_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_consnikboehmME_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Boehmke FD, 2018) Change
/////////////////////
cd "../ConsPolnikboehmFD"

//Fixed effects plot
coefplot CHm_consnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_consnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_consnikboehmFD_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_consnikboehmFD_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_consnikboehmFD_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_consnikboehmFD_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Grumbach, 2018) Change
/////////////////////
cd "../ConsPolnikGrumb"

//Fixed effects plot
coefplot CHm_consnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_consnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_consnikgrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_consnikgrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_consnikgrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_consnikgrumb_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (2019 coding, Grossman, size/scope) Change
/////////////////////
cd "../ConsPol2019size"

//Fixed effects plot
coefplot CHm_cons2019size_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_cons2019size_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_cons2019size_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-1(1)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_cons2019size_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(1)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_cons2019size_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(1)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_cons2019size_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(1)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (2019 coding, Grossman, conventional) Change
/////////////////////
cd "../ConsPol2019conv"

//Fixed effects plot
coefplot CHm_cons2019conv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_cons2019conv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_cons2019conv_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-1(1)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_cons2019conv_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(1)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_cons2019conv_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(1)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_cons2019conv_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(1)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace
///////////////////////////////////////////
