///////////////////////////
// Post estimation: Change models
///////////////////////////
cd "../../OUTPUT/Change/"

/////////////////////
//Lib Policies Change
/////////////////////
cd "LibPol"

//Fixed effects plot
coefplot CHm_libpolicy_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libpolicy_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libpolicy_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3.5(.5)1.5) ysc(range(-3.5 1.5)) yline(-3.5(.25)1.5, lpat(dot)) ytitle("Change in Count Lib. Policies") title("Change in Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libpolicy_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1.5(.5)3.5) ysc(range(-1.5 3.5)) yline(-1.5(.25)3.5, lpat(dot)) ytitle("Change in Count Lib. Policies") title("Change in Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libpolicy_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1.5(.5)3.5) ysc(range(-1.5 3.5)) yline(-1.5(.25)3.5, lpat(dot)) ytitle("Change in Count Lib. Policies") title("Change in Lib. Policy count, no state FE")
graph export "NoStFE_libchange.png",replace

//No NJ/PA (outlier) model
est restore CHm_libpolicy_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1.5(.5)3.5) ysc(range(-1.5 3.5)) yline(-1.5(.25)3.5, lpat(dot)) ytitle("Change in Count Lib. Policies") title("Change in Lib. Policy count, sans outliers")
graph export "NoOutliers_libchange.png",replace

/////////////////////
//Lib Policies (conventional) Change
/////////////////////
cd "../LibPolConv"

//Fixed effects plot
coefplot CHm_libpolicyCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libpolicyCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libpolicyCONV_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libpolicyCONV_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libpolicyCONV_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libpolicyCONV_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Grumbach) Change
/////////////////////
cd "../LibPolGrumb"

//Fixed effects plot
coefplot CHm_libpolGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libpolGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libpolGrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libpolGrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libpolGrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libpolGrumb_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Grsman) Change
/////////////////////
cd "../LibPolGrsman"

//Fixed effects plot
coefplot CHm_libpolGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libpolGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libpolGrsman_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libpolGrsman_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libpolGrsman_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libpolGrsman_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Conv, 2018) Change
/////////////////////
cd "../LibPolnikConv"

//Fixed effects plot
coefplot CHm_libnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libnikconv_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libnikconv_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libnikconv_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libnikconv_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Size/Scope, 2018) Change
/////////////////////
cd "../LibPolnikSizeScope"

//Fixed effects plot
coefplot CHm_libniksizescope_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libniksizescope_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libniksizescope_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libniksizescope_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libniksizescope_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libniksizescope_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Boehmke ME, 2018) Change
/////////////////////
cd "../LibPolnikboehmME"

//Fixed effects plot
coefplot CHm_libnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libnikboehmME_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libnikboehmME_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libnikboehmME_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libnikboehmME_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Boehmke FD, 2018) Change
/////////////////////
cd "../LibPolnikboehmFD"

//Fixed effects plot
coefplot CHm_libnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libnikboehmFD_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-4(1)4) ysc(range(-4 4)) yline(-4(.5)4, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libnikboehmFD_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-4(1)4) ysc(range(-4 4)) yline(-4(.5)4, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libnikboehmFD_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-4(1)4) ysc(range(-4 4)) yline(-4(.5)4, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libnikboehmFD_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-4(1)4) ysc(range(-4 4)) yline(-4(.5)4, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Grumbach, 2018) Change
/////////////////////
cd "../LibPolnikGrumb"

//Fixed effects plot
coefplot CHm_libnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libnikgrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libnikgrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libnikgrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libnikgrumb_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (2019 coding, Grossman, size/scope) Change
/////////////////////
cd "../LibPol2019size"

//Fixed effects plot
coefplot CHm_lib2019size_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_lib2019size_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_lib2019size_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(0(1)5) ysc(range(0 5)) yline(0(.25)5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_lib2019size_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(0(1)5) ysc(range(0 5)) yline(0(.25)5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_lib2019size_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(0(1)5) ysc(range(0 5)) yline(0(.25)5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_lib2019size_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(1)5) ysc(range(-1 5)) yline(-1(.25)5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (2019 coding, Grossman, conventional) Change
/////////////////////
cd "../LibPol2019conv"

//Fixed effects plot
coefplot CHm_lib2019conv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_lib2019conv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_lib2019conv_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(0(1)5) ysc(range(0 5)) yline(0(.25)5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_lib2019conv_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(0(1)5) ysc(range(0 5)) yline(0(.25)5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_lib2019conv_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(0(1)5) ysc(range(0 5)) yline(0(.25)5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_lib2019conv_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(1)5) ysc(range(-1 5)) yline(-1(.25)5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

///////////////////////////////////////////
