///////////////////////////
// Post estimation: Change models
///////////////////////////
cd "../../OUTPUT/Change/"

/////////////////////
//Net Lib Policies Change
/////////////////////
cd "NetLibPol"

//Fixed effects plot
coefplot CHm_netlibpol_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_netlibpol_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibpol_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-4(.5)1) ysc(range(-4 1)) yline(-4(.25)1, lpat(dot)) ytitle("Change in Net Count Lib. Policies") title("Change in Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibpol_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(.5)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change in Net Count Lib. Policies") title("Change in Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibpol_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change in Net Count Lib. Policies") title("Change in Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibchange.png",replace

//No NJ/PA (outlier) model
est restore CHm_netlibpol_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change in Net Count Lib. Policies") title("Change in Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibchange.png",replace

/////////////////////
//Net Lib Policies (conventional) Change
/////////////////////
cd "../NetLibPolConv"

//Fixed effects plot
coefplot CHm_netlibpolCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibpolCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibpolCONV_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibpolCONV_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibpolCONV_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibpolCONV_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Grumbach) Change
/////////////////////
cd "../NetLibPolGrumb"

//Fixed effects plot
coefplot CHm_netlibGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibGrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibGrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibGrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibGrumb_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3(.5)3) ysc(range(-3 3)) yline(-3(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Grsman) Change
/////////////////////
cd "../NetLibPolGrsman"

//Fixed effects plot
coefplot CHm_netlibGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibGrsman_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibGrsman_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibGrsman_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibGrsman_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Conv, 2018) Change
/////////////////////
cd "../NetLibnikConv"

//Fixed effects plot
coefplot CHm_netlibnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibnikconv_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibnikconv_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibnikconv_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibnikconv_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Size/Scope, 2018) Change
/////////////////////
cd "../NetLibnikSizeScope"

//Fixed effects plot
coefplot CHm_netlibnikszscp_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibnikszscp_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibnikszscp_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibnikszscp_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibnikszscp_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibnikszscp_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Boehmke ME, 2018) Change
/////////////////////
cd "../NetLibnikboehmME"

//Fixed effects plot
coefplot CHm_netlibnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibnikboehmME_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-5(1)3) ysc(range(-5 3)) yline(-5(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibnikboehmME_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-5(1)3) ysc(range(-5 3)) yline(-5(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibnikboehmME_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-5(1)3) ysc(range(-5 3)) yline(-5(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibnikboehmME_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-5(1)3) ysc(range(-5 3)) yline(-5(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Boehmke FD, 2018) Change
/////////////////////
cd "../NetLibnikboehmFD"

//Fixed effects plot
coefplot CHm_netlibnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibnikboehmFD_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-6(1)4) ysc(range(-6 4)) yline(-6(.5)4, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibnikboehmFD_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-6(1)4) ysc(range(-6 4)) yline(-6(.5)4, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibnikboehmFD_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-6(1)4) ysc(range(-6 4)) yline(-6(.5)4, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibnikboehmFD_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-6(1)4) ysc(range(-6 4)) yline(-6(.5)4, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Grumbach, 2018) Change
/////////////////////
cd "../NetLibnikGrumb"

//Fixed effects plot
coefplot CHm_netlibnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibnikgrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibnikgrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibnikgrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibnikgrumb_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (2019 coding, Grossman, size/scope) Change
/////////////////////
cd "../NetLib2019size"

//Fixed effects plot
coefplot CHm_netlib2019size_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlib2019size_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlib2019size_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-1(1)5) ysc(range(-1 5)) yline(-1(.5)5, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlib2019size_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(1)5) ysc(range(-1 5)) yline(-1(.5)5, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlib2019size_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(1)5) ysc(range(-1 5)) yline(-1(.5)5, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlib2019size_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(1)5) ysc(range(-1 5)) yline(-1(.5)5, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (2019 coding, Grossman, conventional) Change
/////////////////////
cd "../NetLib2019conv"

//Fixed effects plot
coefplot CHm_netlib2019conv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlib2019conv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlib2019conv_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-1(1)5) ysc(range(-1 5)) yline(-1(.5)5, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlib2019conv_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(1)5) ysc(range(-1 5)) yline(-1(.5)5, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlib2019conv_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(1)5) ysc(range(-1 5)) yline(-1(.5)5, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlib2019conv_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(1)5) ysc(range(-1 5)) yline(-1(.5)5, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

///////////////////////////////////////////
