///////////////////////////
// Post estimation: Change models
///////////////////////////
cd "../../OUTPUT/Change/"

/////////////////////
//Expenditures Change
/////////////////////
cd "Expend"

//Fixed effects plot
coefplot CHm_expend_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Expenditures",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_expendchange.png",replace
coefplot CHm_expend_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Expenditures",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_expendchange.png",replace

//Bare model
est restore CHm_expend_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-1(.5)1.5) ysc(range(-1 1.5)) yline(-1(.125)1.5, lpat(dot)) ytitle("Expenditures change (%GSP)") title("Expenditures change (%GSP), with only South as control")
graph export "Bare_expendchange.png",replace

//Full model
est restore CHm_expend_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(.5)1.5) ysc(range(-1 1.5)) yline(-1(.125)1.5, lpat(dot)) ytitle("Expenditures change (%GSP)") title("Expenditures change (%GSP)")
graph export "Full_expendchange.png",replace

//No st FE model
est restore CHm_expend_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)1.5) ysc(range(-1 1.5)) yline(-1(.125)1.5, lpat(dot)) ytitle("Expenditures change (%GSP)") title("Expenditures change (%GSP), no state FE")
graph export "NoStFE_expend.png",replace

//No NJ/PA (outliers) model
est restore CHm_expend_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)1.5) ysc(range(-1 1.5)) yline(-1(.125)1.5, lpat(dot)) ytitle("Expenditures change (%GSP)") title("Expenditures change (%GSP), sans outliers")
graph export "NoOutliers_expend.png",replace

/////////////////////
//Policy Liberalism Change
/////////////////////
cd "../PolLib"

//Fixed effects plot
coefplot CHm_pollib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy lib change",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_pollibchange.png",replace
coefplot CHm_pollib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy lib change",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_pollibchange.png",replace

//Bare model
est restore CHm_pollib_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-0.4(.2)0.2) ysc(range(-0.4 0.2)) yline(-0.4(.05) 0.2, lpat(dot)) ytitle("Change Policy Lib") title("Change Policy Lib, with only South as control")
graph export "Bare_pollibchange.png",replace

//Full model
est restore CHm_pollib_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.4(.2)0.2) ysc(range(-0.4 0.2)) yline(-0.4(.05) 0.2, lpat(dot)) ytitle("Change Policy Lib") title("Change Policy Lib")
graph export "Full_pollibchange.png",replace

//No yr FE model
est restore CHm_pollib_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.2) ysc(range(-0.4 0.2)) yline(-0.4(.05) 0.2, lpat(dot)) ytitle("Change Policy Lib") title("Change Policy Lib, no state FE")
graph export "NoStFE_pollib.png",replace

//No NJ/PA (outliers) model
est restore CHm_pollib_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.2) ysc(range(-0.4 0.2)) yline(-0.4(.05) 0.2, lpat(dot)) ytitle("Change Policy Lib") title("Change Policy Lib, sans outliers")
graph export "NoOutlier_pollib.png",replace

/////////////////////
//Social Policy Liberalism Change
/////////////////////
cd "../PolLibSoc"

//Fixed effects plot
coefplot CHm_soclib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Soc Policy lib change",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_soclibchange.png",replace
coefplot CHm_soclib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Soc Policy lib change",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_soclibchange.png",replace

//Bare model
est restore CHm_soclib_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Soc Policy Lib") title("Change Soc Policy Lib, with only South as control")
graph export "Bare_soclibchange.png",replace

//Full model
est restore CHm_soclib_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Soc Policy Lib") title("Change Soc Policy Lib")
graph export "Full_soclibchange.png",replace

//No yr FE model
est restore CHm_soclib_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Soc Policy Lib") title("Change Soc Policy Lib, no state FE")
graph export "NoStFE_soclib.png",replace

//No NJ/PA (outliers) model
est restore CHm_soclib_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Soc Policy Lib") title("Change Soc Policy Lib, sans outliers")
graph export "NoOutlier_soclib.png",replace

/////////////////////
//Economic Policy Liberalism Change
/////////////////////
cd "../PolLibEcon"

//Fixed effects plot
coefplot CHm_econlib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Econ Policy lib change",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_econlibchange.png",replace
coefplot CHm_econlib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Econ Policy lib change",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_econlibchange.png",replace

//Bare model
est restore CHm_econlib_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Econ Policy Lib") title("Change Econ Policy Lib, with only South as control")
graph export "Bare_econlibchange.png",replace

//Full model
est restore CHm_econlib_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Econ Policy Lib") title("Change Econ Policy Lib")
graph export "Full_econlibchange.png",replace

//No yr FE model
est restore CHm_econlib_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Econ Policy Lib") title("Change Econ Policy Lib, no state FE")
graph export "NoStFE_econlib.png",replace

//No NJ/PA (outliers) model
est restore CHm_econlib_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Econ Policy Lib") title("Change Econ Policy Lib, sans outliers")
graph export "NoOutlier_econlib.png",replace

/////////////////////
//Innovation Change
/////////////////////
cd "../Innov"

//Fixed effects plot
coefplot CHm_innov_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Policy Innov",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_innov.png",replace
coefplot CHm_innov_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Policy Innov",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_innov.png",replace

//Bare model
est restore CHm_innov_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-.1(.2).3) ysc(range(-.1 .3)) yline(-.1(.05).3, lpat(dot)) ytitle("Change Policy Innov") title("Change Policy Innov, with only South as control")
graph export "Bare_innov.png",replace

//Full model
est restore CHm_innov_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-.1(.2).3) ysc(range(-.1 .3)) yline(-.1(.05).3, lpat(dot)) ytitle("Change Policy Innov") title("Change Policy Innov")
graph export "Full_innov.png",replace

//No st FE model
est restore CHm_innov_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-.1(.2).3) ysc(range(-.1 .3)) yline(-.1(.05).3, lpat(dot)) ytitle("Change Policy Innov") title("Change Policy Inn, no state FE")
graph export "NoStFE_innov.png",replace

//No NJ/PA (outliers) model
est restore CHm_innov_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-.1(.2).3) ysc(range(-.1 .3)) yline(-.1(.05).3, lpat(dot)) ytitle("Change Policy Innov") title("Change Policy Innov, sans outliers")
graph export "NoOutliers_innov.png",replace

///////////////////////////////////////////