///////////////////////////
// Post estimation: Change models
///////////////////////////
cd "../OUTPUT"

/////////////////////
//Lib Policies Change
/////////////////////
cd "Change/LibPol"

//Fixed effects plot
coefplot CHm_libpolicy_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libpolicy_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libpolicy_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3.5(.5)1.5) ysc(range(-3.5 1.5)) yline(-3.5(.25)1.5, lpat(dot)) ytitle("Change in Count Lib. Policies") title("Change in Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libpolicy_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1.5(.5)3.5) ysc(range(-1.5 3.5)) yline(-1.5(.25)3.5, lpat(dot)) ytitle("Change in Count Lib. Policies") title("Change in Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libpolicy_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1.5(.5)3.5) ysc(range(-1.5 3.5)) yline(-1.5(.25)3.5, lpat(dot)) ytitle("Change in Count Lib. Policies") title("Change in Lib. Policy count, no state FE")
graph export "NoStFE_libchange.png",replace

//No NJ/PA (outlier) model
est restore CHm_libpolicy_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1.5(.5)3.5) ysc(range(-1.5 3.5)) yline(-1.5(.25)3.5, lpat(dot)) ytitle("Change in Count Lib. Policies") title("Change in Lib. Policy count, sans outliers")
graph export "NoOutliers_libchange.png",replace

/////////////////////
//Lib Policies (conventional) Change
/////////////////////
cd "../LibPolConv"

//Fixed effects plot
coefplot CHm_libpolicyCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libpolicyCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libpolicyCONV_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libpolicyCONV_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libpolicyCONV_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libpolicyCONV_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Grumbach) Change
/////////////////////
cd "../LibPolGrumb"

//Fixed effects plot
coefplot CHm_libpolGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libpolGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libpolGrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libpolGrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libpolGrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libpolGrumb_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Grsman) Change
/////////////////////
cd "../LibPolGrsman"

//Fixed effects plot
coefplot CHm_libpolGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libpolGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libpolGrsman_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libpolGrsman_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libpolGrsman_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libpolGrsman_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Conv, 2018) Change
/////////////////////
cd "../LibPolnikConv"

//Fixed effects plot
coefplot CHm_libnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libnikconv_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libnikconv_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libnikconv_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libnikconv_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Size/Scope, 2018) Change
/////////////////////
cd "../LibPolnikSizeScope"

//Fixed effects plot
coefplot CHm_libniksizescope_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libniksizescope_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libniksizescope_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libniksizescope_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libniksizescope_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libniksizescope_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Boehmke ME, 2018) Change
/////////////////////
cd "../LibPolnikboehmME"

//Fixed effects plot
coefplot CHm_libnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libnikboehmME_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libnikboehmME_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libnikboehmME_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libnikboehmME_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3.5(1)3.5) ysc(range(-3.5 3.5)) yline(-3.5(.5)3.5, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Boehmke FD, 2018) Change
/////////////////////
cd "../LibPolnikboehmFD"

//Fixed effects plot
coefplot CHm_libnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libnikboehmFD_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-4(1)4) ysc(range(-4 4)) yline(-4(.5)4, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libnikboehmFD_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-4(1)4) ysc(range(-4 4)) yline(-4(.5)4, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libnikboehmFD_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-4(1)4) ysc(range(-4 4)) yline(-4(.5)4, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libnikboehmFD_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-4(1)4) ysc(range(-4 4)) yline(-4(.5)4, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace

/////////////////////
//Lib Policies (Nik coding, Grumbach, 2018) Change
/////////////////////
cd "../LibPolnikGrumb"

//Fixed effects plot
coefplot CHm_libnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_libnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_libchange.png",replace

//Bare model
est restore CHm_libnikgrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, with only South as control")
graph export "Bare_libchange.png",replace

//Full model
est restore CHm_libnikgrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count")
graph export "Full_libchange.png",replace

//No yr FE model
est restore CHm_libnikgrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, no state FE")
graph export "NoStFE_libpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_libnikgrumb_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Lib. Policies") title("Change Lib. Policy count, sans outliers")
graph export "NoOutliers_libpolicy.png",replace


/////////////////////
//Cons Policies Change
/////////////////////
cd "../ConsPol"

//Fixed effects plot
coefplot CHm_conspolicy_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_conspolicy_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_conspolicy_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-0.5(.25)0.5) ysc(range(-0.5 0.5)) yline(-0.5(.125)0.5, lpat(dot)) ytitle("Change in Count Cons. Policies") title("Change in Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_conspolicy_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.5(.25)0.5) ysc(range(-0.5 0.5)) yline(-0.5(.125)0.5, lpat(dot)) ytitle("Change in Count Cons. Policies") title("Change in Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_conspolicy_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.5(.25)0.5) ysc(range(-0.5 0.5)) yline(-0.5(.125)0.5, lpat(dot)) ytitle("Change in Count Cons. Policies") title("Change in Cons. Policy count, no state FE")
graph export "NoStFE_conschange.png",replace

//No NJ/PA (outlier) model
est restore CHm_conspolicy_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.5(.25)0.5) ysc(range(-0.5 0.5)) yline(-0.5(.125)0.5, lpat(dot)) ytitle("Change in Count Cons. Policies") title("Change in Cons. Policy count, sans outliers")
graph export "NoOutliers_conschange.png",replace

/////////////////////
//Cons Policies (conventional) Change
/////////////////////
cd "../ConsPolConv"

//Fixed effects plot
coefplot CHm_conspolicyCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_conspolicyCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_conspolicyCONV_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-1(.25)1) ysc(range(-1 1)) yline(-1(.125)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_conspolicyCONV_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(.25)1) ysc(range(-1 1)) yline(-1(.125)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_conspolicyCONV_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.25)1) ysc(range(-1 1)) yline(-1(.125)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_conspolCONV_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.25)1) ysc(range(-1 1)) yline(-1(.125)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Grumbach) Change
/////////////////////
cd "../ConsPolGrumb"

//Fixed effects plot
coefplot CHm_conspolGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_conspolGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_conspolGrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_conspolGrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_conspolGrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_conspolGrumb_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Grsman) Change
/////////////////////
cd "../ConsPolGrsman"

//Fixed effects plot
coefplot CHm_conspolGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_conspolGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_conspolGrsman_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_conspolGrsman_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_conspolGrsman_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_conspolGrsman_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Conv, 2018) Change
/////////////////////
cd "../ConsPolnikConv"

//Fixed effects plot
coefplot CHm_consnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_consnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_consnikconv_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_consnikconv_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_consnikconv_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_consnikconv_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Size/Scope, 2018) Change
/////////////////////
cd "../ConsPolnikSizeScope"

//Fixed effects plot
coefplot CHm_consniksizescope_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_consniksizescope_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_consniksizescope_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-1(.5)1) ysc(range(-1 1)) yline(-1(.25)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_consniksizescope_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(.5)1) ysc(range(-1 1)) yline(-1(.25)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_consniksizescope_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)1) ysc(range(-1 1)) yline(-1(.25)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_consniksizescope_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)1) ysc(range(-1 1)) yline(-1(.25)1, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Boehmke ME, 2018) Change
/////////////////////
cd "../ConsPolnikboehmME"

//Fixed effects plot
coefplot CHm_consnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_consnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_consnikboehmME_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_consnikboehmME_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_consnikboehmME_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_consnikboehmME_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Boehmke FD, 2018) Change
/////////////////////
cd "../ConsPolnikboehmFD"

//Fixed effects plot
coefplot CHm_consnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_consnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_consnikboehmFD_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_consnikboehmFD_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_consnikboehmFD_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_consnikboehmFD_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace

/////////////////////
//Cons Policies (Nik coding, Grumbach, 2018) Change
/////////////////////
cd "../ConsPolnikGrumb"

//Fixed effects plot
coefplot CHm_consnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_conschange.png",replace
coefplot CHm_consnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Cons. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_conschange.png",replace

//Bare model
est restore CHm_consnikgrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)2) ysc(range(-2 2)) yline(-2(.25)2, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, with only South as control")
graph export "Bare_conschange.png",replace

//Full model
est restore CHm_consnikgrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count")
graph export "Full_conschange.png",replace

//No yr FE model
est restore CHm_consnikgrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, no state FE")
graph export "NoStFE_conspolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_consnikgrumb_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Count Cons. Policies") title("Change Cons. Policy count, sans outliers")
graph export "NoOutliers_conspolicy.png",replace


/////////////////////
//Net Lib Policies Change
/////////////////////
cd "../NetLibPol"

//Fixed effects plot
coefplot CHm_netlibpol_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_libchange.png",replace
coefplot CHm_netlibpol_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Liberal Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibpol_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-4(.5)1) ysc(range(-4 1)) yline(-4(.25)1, lpat(dot)) ytitle("Change in Net Count Lib. Policies") title("Change in Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibpol_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(.5)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change in Net Count Lib. Policies") title("Change in Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibpol_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change in Net Count Lib. Policies") title("Change in Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibchange.png",replace

//No NJ/PA (outlier) model
est restore CHm_netlibpol_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)3) ysc(range(-1 3)) yline(-1(.25)3, lpat(dot)) ytitle("Change in Net Count Lib. Policies") title("Change in Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibchange.png",replace

/////////////////////
//Net Lib Policies (conventional) Change
/////////////////////
cd "../NetLibPolConv"

//Fixed effects plot
coefplot CHm_netlibpolCONV_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibpolCONV_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibpolCONV_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibpolCONV_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibpolCONV_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibpolCONV_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Grumbach) Change
/////////////////////
cd "../NetLibPolGrumb"

//Fixed effects plot
coefplot CHm_netlibGrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibGrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibGrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibGrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibGrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibGrumb_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3(.5)3) ysc(range(-3 3)) yline(-3(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Grsman) Change
/////////////////////
cd "../NetLibPolGrsman"

//Fixed effects plot
coefplot CHm_netlibGrsman_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibGrsman_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibGrsman_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibGrsman_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibGrsman_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibGrsman_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-2(.5)3) ysc(range(-2 3)) yline(-2(.25)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Conv, 2018) Change
/////////////////////
cd "../NetLibnikConv"

//Fixed effects plot
coefplot CHm_netlibnikconv_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibnikconv_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibnikconv_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibnikconv_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibnikconv_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibnikconv_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Size/Scope, 2018) Change
/////////////////////
cd "../NetLibnikSizeScope"

//Fixed effects plot
coefplot CHm_netlibnikszscp_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibnikszscp_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibnikszscp_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibnikszscp_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibnikszscp_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibnikszscp_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-3(1)3) ysc(range(-3 3)) yline(-3(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Boehmke ME, 2018) Change
/////////////////////
cd "../NetLibnikboehmME"

//Fixed effects plot
coefplot CHm_netlibnikboehmME_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibnikboehmME_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibnikboehmME_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-5(1)3) ysc(range(-5 3)) yline(-5(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibnikboehmME_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-5(1)3) ysc(range(-5 3)) yline(-5(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibnikboehmME_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-5(1)3) ysc(range(-5 3)) yline(-5(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibnikboehmME_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-5(1)3) ysc(range(-5 3)) yline(-5(.5)3, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Boehmke FD, 2018) Change
/////////////////////
cd "../NetLibnikboehmFD"

//Fixed effects plot
coefplot CHm_netlibnikboehmFD_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibnikboehmFD_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibnikboehmFD_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-6(1)4) ysc(range(-6 4)) yline(-6(.5)4, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibnikboehmFD_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-6(1)4) ysc(range(-6 4)) yline(-6(.5)4, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibnikboehmFD_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-6(1)4) ysc(range(-6 4)) yline(-6(.5)4, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibnikboehmFD_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-6(1)4) ysc(range(-6 4)) yline(-6(.5)4, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Net Lib Policies (Nik coding, Grumbach, 2018) Change
/////////////////////
cd "../NetLibnikGrumb"

//Fixed effects plot
coefplot CHm_netlibnikgrumb_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_netlibchange.png",replace
coefplot CHm_netlibnikgrumb_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Net Lib. Policy count",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_netlibchange.png",replace

//Bare model
est restore CHm_netlibnikgrumb_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, with only South as control")
graph export "Bare_netlibchange.png",replace

//Full model
est restore CHm_netlibnikgrumb_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count")
graph export "Full_netlibchange.png",replace

//No yr FE model
est restore CHm_netlibnikgrumb_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, no state FE")
graph export "NoStFE_netlibpolicy.png",replace

//No NJ/PA (outliers) model
est restore CHm_netlibnikgrumb_noout
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-50(25)50) ysc(range(-50 50)) yline(-50(12.5)50, lpat(dot)) ytitle("Change Net Count Lib. Policies") title("Change Net Lib. Policy count, sans outliers")
graph export "NoOutliers_netlibpolicy.png",replace

/////////////////////
//Expenditures Change
/////////////////////
cd "../Expend"

//Fixed effects plot
coefplot CHm_expend_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Expenditures",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_expendchange.png",replace
coefplot CHm_expend_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Expenditures",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_expendchange.png",replace

//Bare model
est restore CHm_expend_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-1(.5)1.5) ysc(range(-1 1.5)) yline(-1(.125)1.5, lpat(dot)) ytitle("Expenditures change (%GSP)") title("Expenditures change (%GSP), with only South as control")
graph export "Bare_expendchange.png",replace

//Full model
est restore CHm_expend_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-1(.5)1.5) ysc(range(-1 1.5)) yline(-1(.125)1.5, lpat(dot)) ytitle("Expenditures change (%GSP)") title("Expenditures change (%GSP)")
graph export "Full_expendchange.png",replace

//No st FE model
est restore CHm_expend_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)1.5) ysc(range(-1 1.5)) yline(-1(.125)1.5, lpat(dot)) ytitle("Expenditures change (%GSP)") title("Expenditures change (%GSP), no state FE")
graph export "NoStFE_expend.png",replace

//No NJ/PA (outliers) model
est restore CHm_expend_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-1(.5)1.5) ysc(range(-1 1.5)) yline(-1(.125)1.5, lpat(dot)) ytitle("Expenditures change (%GSP)") title("Expenditures change (%GSP), sans outliers")
graph export "NoOutliers_expend.png",replace

/////////////////////
//Policy Liberalism Change
/////////////////////
cd "../PolLib"

//Fixed effects plot
coefplot CHm_pollib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy lib change",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_pollibchange.png",replace
coefplot CHm_pollib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Policy lib change",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_pollibchange.png",replace

//Bare model
est restore CHm_pollib_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-0.4(.2)0.2) ysc(range(-0.4 0.2)) yline(-0.4(.05) 0.2, lpat(dot)) ytitle("Change Policy Lib") title("Change Policy Lib, with only South as control")
graph export "Bare_pollibchange.png",replace

//Full model
est restore CHm_pollib_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.4(.2)0.2) ysc(range(-0.4 0.2)) yline(-0.4(.05) 0.2, lpat(dot)) ytitle("Change Policy Lib") title("Change Policy Lib")
graph export "Full_pollibchange.png",replace

//No yr FE model
est restore CHm_pollib_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.2) ysc(range(-0.4 0.2)) yline(-0.4(.05) 0.2, lpat(dot)) ytitle("Change Policy Lib") title("Change Policy Lib, no state FE")
graph export "NoStFE_pollib.png",replace

//No NJ/PA (outliers) model
est restore CHm_pollib_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.2) ysc(range(-0.4 0.2)) yline(-0.4(.05) 0.2, lpat(dot)) ytitle("Change Policy Lib") title("Change Policy Lib, sans outliers")
graph export "NoOutlier_pollib.png",replace

/////////////////////
//Social Policy Liberalism Change
/////////////////////
cd "../PolLibSoc"

//Fixed effects plot
coefplot CHm_soclib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Soc Policy lib change",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_soclibchange.png",replace
coefplot CHm_soclib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Soc Policy lib change",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_soclibchange.png",replace

//Bare model
est restore CHm_soclib_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Soc Policy Lib") title("Change Soc Policy Lib, with only South as control")
graph export "Bare_soclibchange.png",replace

//Full model
est restore CHm_soclib_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Soc Policy Lib") title("Change Soc Policy Lib")
graph export "Full_soclibchange.png",replace

//No yr FE model
est restore CHm_soclib_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Soc Policy Lib") title("Change Soc Policy Lib, no state FE")
graph export "NoStFE_soclib.png",replace

//No NJ/PA (outliers) model
est restore CHm_soclib_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Soc Policy Lib") title("Change Soc Policy Lib, sans outliers")
graph export "NoOutlier_soclib.png",replace

/////////////////////
//Economic Policy Liberalism Change
/////////////////////
cd "../PolLibEcon"

//Fixed effects plot
coefplot CHm_econlib_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Econ Policy lib change",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_econlibchange.png",replace
coefplot CHm_econlib_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Econ Policy lib change",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_econlibchange.png",replace

//Bare model
est restore CHm_econlib_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Econ Policy Lib") title("Change Econ Policy Lib, with only South as control")
graph export "Bare_econlibchange.png",replace

//Full model
est restore CHm_econlib_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Econ Policy Lib") title("Change Econ Policy Lib")
graph export "Full_econlibchange.png",replace

//No yr FE model
est restore CHm_econlib_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Econ Policy Lib") title("Change Econ Policy Lib, no state FE")
graph export "NoStFE_econlib.png",replace

//No NJ/PA (outliers) model
est restore CHm_econlib_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-0.4(.2)0.3) ysc(range(-0.4 0.3)) yline(-0.4(.05) 0.3, lpat(dot)) ytitle("Change Econ Policy Lib") title("Change Econ Policy Lib, sans outliers")
graph export "NoOutlier_econlib.png",replace

/////////////////////
//Innovation Change
/////////////////////
cd "../Innov"

//Fixed effects plot
coefplot CHm_innov_bare,keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Policy Innov",size(small)) sort title("State-fixed effects",size(small)) subtitle("bare model",size(vsmall))
graph export "Bare_FE_innov.png",replace
coefplot CHm_innov_ctls, keep(*.stated) ylab(,labsize(tiny)) msize(tiny) mcolor(black) xtitle("Change Policy Innov",size(small)) sort title("State-fixed effects",size(small))
graph export "Full_FE_innov.png",replace

//Bare model
est restore CHm_innov_bare
margins rep_change_factor,at((asobserved) south stated)
marginsplot, ylabel(-.1(.2).3) ysc(range(-.1 .3)) yline(-.1(.05).3, lpat(dot)) ytitle("Change Policy Innov") title("Change Policy Innov, with only South as control")
graph export "Bare_innov.png",replace

//Full model
est restore CHm_innov_ctls
margins rep_change_factor,at((mean) _all (asobserved) region stated)
marginsplot, ylabel(-.1(.2).3) ysc(range(-.1 .3)) yline(-.1(.05).3, lpat(dot)) ytitle("Change Policy Innov") title("Change Policy Innov")
graph export "Full_innov.png",replace

//No st FE model
est restore CHm_innov_nostfe
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-.1(.2).3) ysc(range(-.1 .3)) yline(-.1(.05).3, lpat(dot)) ytitle("Change Policy Innov") title("Change Policy Inn, no state FE")
graph export "NoStFE_innov.png",replace

//No NJ/PA (outliers) model
est restore CHm_innov_nooutlier
margins rep_change_factor,at((mean) _all (asobserved) region)
marginsplot, ylabel(-.1(.2).3) ysc(range(-.1 .3)) yline(-.1(.05).3, lpat(dot)) ytitle("Change Policy Innov") title("Change Policy Innov, sans outliers")
graph export "NoOutliers_innov.png",replace

///////////////////////////////////////////